/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jpos.config.JposRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public abstract class AbstractRegPopulator
implements JposRegPopulator {
    private Hashtable jposEntries = new Hashtable();
    private InputStream populatorIS = null;
    private OutputStream populatorOS = null;
    private String populatorFileName = "";
    private String populatorFileURL = "";
    private String uniqueId = "";
    protected Exception lastLoadException = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("AbstractRegPopulator");

    public AbstractRegPopulator(String string) {
        this.setUniqueId(string);
    }

    public abstract void save(Enumeration var1) throws Exception;

    public abstract void save(Enumeration var1, String var2) throws Exception;

    public abstract void load();

    public abstract void load(String var1);

    public abstract URL getEntriesURL();

    public abstract String getName();

    public String getUniqueId() {
        return this.uniqueId.equals("") ? this.getClassName() : this.uniqueId;
    }

    public Enumeration getEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.jposEntries.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public boolean isComposite() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public Exception getLastLoadException() {
        return this.lastLoadException;
    }

    protected URL createURLFromFile(File file) {
        URL uRL = null;
        try {
            uRL = new URL("file", "", file.getAbsolutePath());
        }
        catch (Exception exception) {
            this.tracer.println("Error creating URL: Exception.message=" + exception.getMessage());
        }
        return uRL;
    }

    protected URL createURLFromFile(ZipFile zipFile) {
        URL uRL = null;
        try {
            uRL = new URL("jar", "", new File(zipFile.getName()).getAbsolutePath());
        }
        catch (Exception exception) {
            this.tracer.println("Error creating URL: Exception.message=" + exception.getMessage());
        }
        return uRL;
    }

    protected Hashtable getJposEntries() {
        return this.jposEntries;
    }

    protected boolean isPopulatorFileDefined() {
        boolean bl = false;
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            bl = true;
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            bl = true;
        }
        return bl;
    }

    protected InputStream getPopulatorFileIS() throws Exception {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            this.populatorFileName = jposProperties.getPropertyString("jpos.config.populatorFile");
            this.tracer.println("getPopulatorFileIS(): populatorFileName=" + this.populatorFileName);
            this.populatorIS = new FileInputStream(this.populatorFileName);
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            this.populatorFileURL = jposProperties.getPropertyString("jpos.config.populatorFileURL");
            URL uRL = new URL(this.populatorFileURL);
            this.populatorIS = uRL.openStream();
            this.tracer.println("getPopulatorFileIS(): populatorFileURL=" + this.populatorFileURL);
        } else {
            String string = "jpos.config.populatorFile OR  jpos.config.populatorFileURL properties not defined";
            this.tracer.println(string);
            throw new Exception(string);
        }
        return this.populatorIS;
    }

    protected OutputStream getPopulatorFileOS() throws Exception {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            this.populatorFileName = jposProperties.getPropertyString("jpos.config.populatorFile");
            this.populatorOS = new FileOutputStream(this.populatorFileName);
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            this.populatorFileURL = jposProperties.getPropertyString("jpos.config.populatorFileURL");
            URL uRL = new URL(this.populatorFileURL);
            this.populatorOS = uRL.openConnection().getOutputStream();
        } else {
            String string = "jpos.config.populatorFile OR jpos.config.populatorFileURL properties not defined";
            this.tracer.println(string);
            throw new Exception(string);
        }
        return this.populatorOS;
    }

    protected String getPopulatorFileName() {
        return this.populatorFileName;
    }

    protected String getPopulatorFileURL() {
        return this.populatorFileURL;
    }

    protected void setUniqueId(String string) {
        this.uniqueId = string;
    }

    protected InputStream findFileInClasspath(String string) {
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        String string4 = System.getProperty("file.separator");
        BufferedInputStream bufferedInputStream = null;
        if (string.startsWith(".") || string.startsWith(string4)) {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            }
            catch (IOException iOException) {
                bufferedInputStream = null;
                this.tracer.println("findFileInClasspath: IOException.msg=" + iOException.getMessage());
            }
            return bufferedInputStream;
        }
        String string5 = "";
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, false);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                string5 = stringTokenizer.nextToken().trim();
                if (string5.equals("")) continue;
                if (string5.length() > 4 && (string5.endsWith(".zip") || string5.endsWith(".jar"))) {
                    vector.addElement(string5);
                    continue;
                }
                String string6 = string5 + (string.startsWith(string4) || string5.endsWith(string4) ? "" : string4) + string;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string6));
                break;
            }
            catch (Exception exception) {
            }
        }
        if (bufferedInputStream == null) {
            return this.findFileInJarZipFiles(string, vector);
        }
        return bufferedInputStream;
    }

    protected InputStream findFileInJarZipFiles(String string, Vector vector) {
        BufferedInputStream bufferedInputStream = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            try {
                ZipFile zipFile = new ZipFile(string2);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string3 = zipEntry.getName();
                    if (!string3.endsWith(string)) continue;
                    bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    break;
                }
            }
            catch (Exception exception) {
                this.tracer.println("findInJarZipFiles: Exception.message=" + exception.getMessage());
            }
            if (bufferedInputStream != null) break;
        }
        return bufferedInputStream;
    }
}

