/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicencePanel
extends IzPanel
implements ActionListener {
    private String licence;
    private JTextArea textArea;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;
    private JScrollPane scroller;

    public LicencePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.setLayout(new BoxLayout(this, 1));
        this.loadLicence();
        JLabel infoLabel = LabelFactory.create(parent.langpack.getString("LicencePanel.info"), parent.icons.getImageIcon("history"), 11);
        this.add(infoLabel);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        this.textArea = new JTextArea(this.licence);
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scroller = new JScrollPane(this.textArea);
        this.scroller.setAlignmentX(0.0f);
        this.add(this.scroller);
        ButtonGroup group = new ButtonGroup();
        this.yesRadio = new JRadioButton(parent.langpack.getString("LicencePanel.agree"), false);
        group.add(this.yesRadio);
        this.add(this.yesRadio);
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(parent.langpack.getString("LicencePanel.notagree"), true);
        group.add(this.noRadio);
        this.add(this.noRadio);
        this.noRadio.addActionListener(this);
    }

    private void loadLicence() {
        try {
            String resNamePrifix = "LicencePanel.licence";
            this.licence = ResourceManager.getInstance().getTextResource(resNamePrifix);
        }
        catch (Exception err) {
            this.licence = "Error : could not load the licence text !";
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

