/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.transport.DLSPort;
import com.dls.jpos.transport.DLSUsbQuery;
import com.ibm.jusb.UsbPipeImp;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbPipe;
import javax.usb.UsbServices;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;
import javax.usb.util.UsbUtil;

public class DLSUsbJavax
extends DLSPort
implements UsbDeviceListener,
UsbServicesListener {
    protected UsbInterface usbInterface = null;
    protected ReadData rd = null;
    private boolean bLiveWeight = false;
    private int nPollRate = 1000;
    private boolean isRunning = false;
    private byte[] weightCmd;
    private LiveWeightThread thrLiveWeight = new LiveWeightThread();
    private final Object deviceClassLock = new Object();
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public DLSUsbJavax(DLSDeviceInfo info) {
        super(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openPort() {
        boolean bRc = true;
        Object object = this.deviceClassLock;
        synchronized (object) {
            this.log.in(this, "openPort");
            this.closePort();
            DLSUsbQuery query = new DLSUsbQuery();
            UsbEndpoint usbEndpoint = null;
            UsbPipe usbPipe = null;
            try {
                this.usbInterface = query.findDevice(this.info);
                if (this.usbInterface == null) {
                    return false;
                }
                this.usbInterface.claim();
                List usbEndpoints = this.usbInterface.getUsbEndpoints();
                for (int i = 0; i < usbEndpoints.size() && (3 != (usbEndpoint = (UsbEndpoint)usbEndpoints.get(i)).getType() || -128 != usbEndpoint.getDirection()); ++i) {
                }
                usbPipe = usbEndpoint.getUsbPipe();
                usbPipe.open();
                ReadData i = this.rd = new ReadData(usbPipe);
                synchronized (i) {
                    Thread rdThread = new Thread(this.rd);
                    rdThread.start();
                    try {
                        this.rd.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                this.bOpen = true;
            }
            catch (DLSException p) {
                this.log.error(this, p.getMessage());
                bRc = false;
            }
            catch (UsbException u) {
                this.log.error(this, u.getMessage());
                bRc = false;
            }
            catch (UsbNotActiveException na) {
                this.log.error(this, na.getMessage());
                bRc = false;
            }
            catch (UsbNotClaimedException nc) {
                this.log.error(this, nc.getMessage());
                bRc = false;
            }
            catch (UsbDisconnectedException dc) {
                this.log.error(this, dc.getMessage());
                bRc = false;
            }
            if (!bRc) {
                this.usbInterface = null;
                usbPipe = null;
                usbEndpoint = null;
            } else {
                UsbDevice usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
                if (usbDevice != null) {
                    usbDevice.removeUsbDeviceListener((UsbDeviceListener)this);
                    usbDevice.addUsbDeviceListener((UsbDeviceListener)this);
                }
                UsbServices services = null;
                try {
                    services = UsbHostManager.getUsbServices();
                    services.removeUsbServicesListener((UsbServicesListener)this);
                    services.addUsbServicesListener((UsbServicesListener)this);
                }
                catch (UsbException e) {
                    this.log.error(this, "UsbException: " + e.getMessage());
                }
                catch (SecurityException e) {
                    this.log.error(this, "SecurityException: " + e.getMessage());
                }
            }
            this.log.out(this, "openPort: " + bRc);
        }
        return bRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closePort() {
        this.bOpen = false;
        Object object = this.deviceClassLock;
        synchronized (object) {
            block13: {
                this.log.in(this, "closePort");
                UsbServices services = null;
                try {
                    services = UsbHostManager.getUsbServices();
                    services.removeUsbServicesListener((UsbServicesListener)this);
                }
                catch (UsbException e) {
                    this.log.error(this, "UsbException: " + e.getMessage());
                }
                catch (SecurityException e) {
                    this.log.error(this, "SecurityException: " + e.getMessage());
                }
                try {
                    if (this.rd != null) {
                        if (this.rd.running) {
                            this.rd.stop();
                        }
                        this.rd = null;
                    }
                    if (this.usbInterface == null) break block13;
                    UsbDevice usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
                    if (usbDevice != null) {
                        usbDevice.removeUsbDeviceListener((UsbDeviceListener)this);
                    }
                    try {
                        this.usbInterface.release();
                    }
                    catch (UsbDisconnectedException de) {
                        // empty catch block
                    }
                    this.usbInterface = null;
                }
                catch (UsbException e) {
                    this.log.trace(this, "UsbException Thrown:" + e.getMessage());
                }
            }
            this.log.out(this, "closePort");
        }
        return true;
    }

    public void changeBaudRate(int nBaud) {
    }

    public int sendData(byte[] buf, int len) {
        if (!this.bLiveWeight) {
            this.log.in(this, "sendData");
        }
        int nBytes = 0;
        if (this.usbInterface == null) {
            this.log.log(this, "no USB interface");
            return nBytes;
        }
        if (null == this.rd || !this.rd.running) {
            return nBytes;
        }
        UsbDevice usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
        UsbControlIrp usageIrp = usbDevice.createUsbControlIrp((byte)33, (byte)9, (short)512, UsbUtil.unsignedShort((byte)this.usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber()));
        usageIrp.setOffset(0);
        usageIrp.setData(buf);
        try {
            usbDevice.syncSubmit(usageIrp);
            nBytes = usageIrp.getActualLength();
            String logData = "";
            for (int i = 0; i < len; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            if (!this.bLiveWeight) {
                this.log.log(this, "# raw bytes sent[" + len + "]" + logData);
            }
        }
        catch (UsbException e) {
            this.log.error(this, "Error sending data: " + e.getMessage());
        }
        if (!this.bLiveWeight) {
            this.log.out(this, "sendData");
        }
        return nBytes;
    }

    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        if (this.bLiveWeight) {
            return false;
        }
        this.log.in(this, "startLiveWeight");
        this.weightCmd = buf;
        this.nPollRate = rate;
        this.thrLiveWeight = new LiveWeightThread();
        this.thrLiveWeight.bLiveWeight = true;
        this.bLiveWeight = true;
        this.thrLiveWeight.start();
        this.log.out(this, "startLiveWeight");
        return true;
    }

    public void stopLiveWeight() {
        this.thrLiveWeight.bLiveWeight = false;
        this.bLiveWeight = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbDeviceDetached(UsbDeviceEvent event) {
        Object object = this.deviceClassLock;
        synchronized (object) {
            this.log.trace(this, "Device Removed: " + Integer.toHexString(this.info.getVendorId()) + "," + Integer.toHexString(this.info.getProductId()));
            this.closePort();
            UsbServices services = null;
            try {
                services = UsbHostManager.getUsbServices();
                services.addUsbServicesListener((UsbServicesListener)this);
            }
            catch (UsbException e) {
                this.log.error(this, "UsbException: " + e.getMessage());
            }
            catch (SecurityException e) {
                this.log.error(this, "SecurityException: " + e.getMessage());
            }
            this.fireDeviceRemovedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbDeviceDetached() {
        Object object = this.deviceClassLock;
        synchronized (object) {
            this.log.trace(this, "Device Removed: " + Integer.toHexString(this.info.getVendorId()) + "," + Integer.toHexString(this.info.getProductId()));
            this.closePort();
            UsbServices services = null;
            try {
                services = UsbHostManager.getUsbServices();
                services.addUsbServicesListener((UsbServicesListener)this);
            }
            catch (UsbException e) {
                this.log.error(this, "UsbException: " + e.getMessage());
            }
            catch (SecurityException e) {
                this.log.error(this, "SecurityException: " + e.getMessage());
            }
            this.fireDeviceRemovedEvent();
        }
    }

    public void errorEventOccurred(UsbDeviceErrorEvent event) {
        this.log.error(this, "ErrorEventOccured on usb: " + event.getUsbException().getMessage());
    }

    public void dataEventOccurred(UsbDeviceDataEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbDeviceAttached(UsbServicesEvent event) {
        Object object = this.deviceClassLock;
        synchronized (object) {
            this.log.in(this, "usbDeviceAttached, isOpen=" + this.isOpen());
            if (!this.isOpen()) {
                DLSUsbQuery query = new DLSUsbQuery();
                UsbInterface anInterface = null;
                try {
                    anInterface = query.findDevice(this.info);
                }
                catch (DLSException e) {
                    // empty catch block
                }
                if (anInterface != null) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        this.log.error(this, "can't sleep: " + ex.getMessage());
                    }
                    this.log.trace(this, "Device Reattached: " + Integer.toHexString(this.info.getVendorId()) + "," + Integer.toHexString(this.info.getProductId()));
                    this.fireDeviceReattachedEvent();
                }
            }
            this.log.out(this, "usbDeviceAttached");
        }
    }

    public void usbDeviceDetached(UsbServicesEvent event) {
    }

    public class JavaClassPath {
        public void add(File path) throws Exception {
            String newLibraryPath = System.getProperty("java.class.path");
            newLibraryPath = newLibraryPath == null || newLibraryPath.length() < 1 ? path.getCanonicalPath() : newLibraryPath + File.pathSeparator + path.getCanonicalPath();
            Field f = (class$java$lang$System == null ? (class$java$lang$System = DLSUsbJavax.class$("java.lang.System")) : class$java$lang$System).getDeclaredField("props");
            f.setAccessible(true);
            Properties props = (Properties)f.get(null);
            props.put("java.class.path", newLibraryPath);
            Field usr_pathsField = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DLSUsbJavax.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("usr_paths");
            usr_pathsField.setAccessible(true);
            String[] usr_paths = (String[])usr_pathsField.get(null);
            String[] newUsr_paths = new String[usr_paths == null ? 1 : usr_paths.length + 1];
            if (usr_paths != null) {
                System.arraycopy(usr_paths, 0, newUsr_paths, 0, usr_paths.length);
            }
            newUsr_paths[newUsr_paths.length - 1] = path.getAbsolutePath();
            usr_pathsField.set(null, newUsr_paths);
        }

        public void add(String sPath) throws Exception {
            File path = new File(sPath);
            this.add(path);
        }
    }

    public class JavaLibraryPath {
        public void add(File path) throws Exception {
            String newLibraryPath = System.getProperty("java.library.path");
            newLibraryPath = newLibraryPath == null || newLibraryPath.length() < 1 ? path.getCanonicalPath() : newLibraryPath + File.pathSeparator + path.getCanonicalPath();
            Field f = (class$java$lang$System == null ? (class$java$lang$System = DLSUsbJavax.class$("java.lang.System")) : class$java$lang$System).getDeclaredField("props");
            f.setAccessible(true);
            Properties props = (Properties)f.get(null);
            props.put("java.library.path", newLibraryPath);
            Field usr_pathsField = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DLSUsbJavax.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("usr_paths");
            usr_pathsField.setAccessible(true);
            String[] usr_paths = (String[])usr_pathsField.get(null);
            String[] newUsr_paths = new String[usr_paths == null ? 1 : usr_paths.length + 1];
            if (usr_paths != null) {
                System.arraycopy(usr_paths, 0, newUsr_paths, 0, usr_paths.length);
            }
            newUsr_paths[newUsr_paths.length - 1] = path.getAbsolutePath();
            usr_pathsField.set(null, newUsr_paths);
        }

        public void add(String sPath) throws Exception {
            File path = new File(sPath);
            this.add(path);
        }
    }

    private class LiveWeightThread
    extends Thread {
        public boolean bLiveWeight = false;

        private LiveWeightThread() {
        }

        public void run() {
            DLSUsbJavax.this.log.log(this, "Starting live weight.");
            while (this.bLiveWeight) {
                try {
                    if (DLSUsbJavax.this.log.getFWBusy()) {
                        LiveWeightThread.sleep(15000L);
                    } else {
                        LiveWeightThread.sleep(DLSUsbJavax.this.nPollRate);
                    }
                }
                catch (InterruptedException e) {
                    DLSUsbJavax.this.log.error(this, "liveweight sleep interrupted");
                }
                DLSUsbJavax.this.sendData(DLSUsbJavax.this.weightCmd, DLSUsbJavax.this.weightCmd.length);
            }
            DLSUsbJavax.this.log.log(this, "End live weight.");
        }
    }

    public class ReadData
    implements Runnable {
        public boolean running = true;
        public UsbPipe usbPipe = null;

        public ReadData(UsbPipe pipe) {
            this.usbPipe = pipe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DLSUsbJavax.this.log.in(this, "run");
            byte[] data = new byte[UsbUtil.unsignedInt((short)this.usbPipe.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize())];
            int length = 0;
            ReadData readData = this;
            synchronized (readData) {
                this.notifyAll();
            }
            while (this.running) {
                block6: {
                    try {
                        length = this.usbPipe.syncSubmit(data);
                    }
                    catch (UsbException e) {
                        if (!this.running) break block6;
                        this.running = false;
                        DLSUsbJavax.this.log.error(this, "Severe UsbException in ReadData: " + e.getMessage());
                        DLSUsbJavax.this.usbDeviceDetached();
                        break;
                    }
                }
                if (!this.running || length == 0) continue;
                String logData = UsbUtil.toHexString((String)" 0x", (byte[])data, (int)length);
                DLSUsbJavax.this.log.trace(this, "bytes received[" + length + "]" + logData);
                DLSUsbJavax.this.fireDataReceivedEvent(data, length);
            }
            DLSUsbJavax.this.log.out(this, "run");
        }

        public void stop() {
            DLSUsbJavax.this.log.in(this, "stop()");
            try {
                this.running = false;
                UsbPipeImp pipeImp = (UsbPipeImp)this.usbPipe;
                pipeImp.getUsbPipeOsImp().abortAllSubmissions();
                this.usbPipe.close();
                this.usbPipe = null;
            }
            catch (Exception e) {
                DLSUsbJavax.this.log.error(this, "Stop() exception: " + e.getMessage());
            }
            DLSUsbJavax.this.log.out(this, "stop()");
        }
    }
}

