/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.transport.DLSPort;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class DLSTCPIPPort
extends DLSPort {
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected static final int RECEIVE_THRESHOLD = 1;
    protected static final int RECEIVE_TIMEOUT = 40;
    protected byte[] readBuffer = new byte[2048];
    protected String logData = "";
    protected int nOpens = 0;
    public String strPort;
    public static Socket kkSocket;
    public static PrintWriter out;
    public static BufferedReader in;
    public static String inMsg;
    static stEnum inState;
    public static char[] fBuff;
    public static byte[] tBuff;
    char[] inCharArray = new char[1024000];
    byte[] bytesRead = new byte[2048000];
    public static FileOutputStream fOutStream;
    public static String ipAddr;
    private static boolean hostThreadRunning;
    private static boolean hostConnected;
    public static byte htpEnable;
    public static byte htpDisable;
    public static byte htpConnected;
    public static byte htpTest;
    public static String htpConnectedData;
    public static int hostPortNum;
    public static String logFileName;
    public static FileWriter logFile;
    public static boolean loggingEnabled;
    public static boolean saveImageFiles;
    public static char[] inInt;
    public static char[] inInt2;
    public static int[] extraMsgType;
    public static int[] extraMsgNum;
    static tcpipThread tcpipT;
    static /* synthetic */ Class class$com$dls$jpos$transport$DLSTCPIPPort$stEnum;

    public DLSTCPIPPort(DLSDeviceInfo info) {
        super(info);
    }

    public boolean openPort() {
        this.log.in(this, "openPort");
        String ipPortNum = this.info.getIPPort();
        hostPortNum = Integer.parseInt(ipPortNum);
        ipAddr = this.info.getIPAddress();
        this.log.trace(this, "IP Address: " + ipAddr);
        this.log.trace(this, "Port: " + hostPortNum + ", reported from jpos.xml");
        this.bOpen = false;
        if (this.nOpens == 0) {
            new Thread(new tcpipThread()).start();
            ++this.nOpens;
            this.bOpen = true;
        } else {
            this.log.error(this, "Port: " + this.strPort + ", not found");
        }
        this.log.out(this, "openPort: " + this.bOpen + ", nOpens=" + this.nOpens);
        return this.bOpen;
    }

    public void hostConnect() {
        try {
            kkSocket = new Socket(ipAddr, hostPortNum);
            in = new BufferedReader(new InputStreamReader(kkSocket.getInputStream(), "ISO-8859-1"));
            hostThreadRunning = true;
            out = new PrintWriter(kkSocket.getOutputStream(), true);
            hostConnected = true;
        }
        catch (UnknownHostException e) {
            this.log.error(this, "Unknown Host: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.error(this, "Connection Error: " + e.getMessage());
        }
    }

    public String getPortName() {
        return this.strPort;
    }

    public boolean closePort() {
        this.log.in(this, "closePort");
        try {
            this.log.log(this, "closePort: nOpens = " + this.nOpens);
            --this.nOpens;
            if (this.nOpens <= 0) {
                this.log.log(this, "closePort: nOpens <= 0 = " + this.nOpens);
                if (this.strPort != null) {
                    this.log.log(this, "closePort: port != null");
                    this.log.log(this, "closePort: TCPPort");
                    this.inputStream.close();
                    this.outputStream.close();
                    this.inputStream = null;
                    this.outputStream = null;
                    this.hostDisconnect();
                }
                this.nOpens = 0;
                this.bOpen = false;
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error closing port: " + e.getMessage());
        }
        this.log.out(this, "closePort");
        return true;
    }

    public void hostDisconnect() {
        try {
            System.out.println("Stopping Host monitor thread...");
            hostThreadRunning = false;
            System.out.println("Closing Socket...");
            hostConnected = false;
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (kkSocket != null) {
                kkSocket.close();
            }
        }
        catch (UnknownHostException e) {
            this.log.error(this, "Unknown Host: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.error(this, "Connection Error: " + e.getMessage());
        }
    }

    public int sendData(byte[] buf, int len) {
        int nBytes = buf.length;
        this.logData = "";
        for (int i = 0; i < nBytes; ++i) {
            this.logData = this.logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.trace(this, "bytes sent[" + nBytes + "]" + this.logData);
        if (!hostConnected) {
            this.hostConnect();
        }
        DLSTCPIPPort.hostSend(buf[0], buf.toString());
        return nBytes;
    }

    public static void hostSend(byte mtype, String mbody) {
        out.write(mtype);
        int strLen = mbody.length();
        byte len = (byte)(0xFF & strLen / 0x1000000);
        out.write(len);
        len = (byte)(0xFF & strLen / 65536);
        out.write(len);
        len = (byte)(0xFF & strLen / 256);
        out.write(len);
        len = (byte)(0xFF & strLen);
        out.write(len);
        out.println(mbody);
    }

    public void hostGetAll() {
        boolean bNotFound = false;
        while (true) {
            try {
                while (true) {
                    int i;
                    int msgLen;
                    if (!hostThreadRunning) {
                        continue;
                    }
                    char inChar = (char)in.read();
                    switch (inChar) {
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'F': 
                        case 'I': 
                        case 'L': 
                        case 'O': 
                        case 'P': 
                        case 'T': 
                        case 'U': 
                        case 'V': {
                            break;
                        }
                        default: {
                            bNotFound = true;
                        }
                    }
                    if (bNotFound) {
                        bNotFound = false;
                        continue;
                    }
                    if (inChar == 'P') {
                        int total = 0;
                        in.read(inInt, 0, 4);
                        msgLen = inInt[0];
                        msgLen = 256 * msgLen + inInt[1];
                        msgLen = 256 * msgLen + inInt[2];
                        msgLen = 256 * msgLen + inInt[3];
                        in.read(inInt2, 0, 4);
                        int imageID = inInt2[0];
                        imageID = 256 * imageID + inInt2[1];
                        imageID = 256 * imageID + inInt2[2];
                        imageID = 256 * imageID + inInt2[3];
                        int imgOrientation = in.read();
                        int imgFormat = in.read();
                        String fname = "ps" + imageID + ".jpg";
                        DLSTCPIPPort.inInt[3] = (char)(fname.length() + inInt2.length + 2);
                        char[] fnameCharArray = fname.toCharArray();
                        this.bytesRead = new byte[inInt[3] * 2 + 10];
                        this.bytesRead[0] = (byte)inChar;
                        this.bytesRead[1] = (byte)(inInt[0] & 0xFF);
                        this.bytesRead[2] = (byte)(inInt[1] & 0xFF);
                        this.bytesRead[3] = (byte)(inInt[2] & 0xFF);
                        this.bytesRead[4] = (byte)(inInt[3] & 0xFF);
                        this.bytesRead[5] = (byte)(inInt2[0] & 0xFF);
                        this.bytesRead[6] = (byte)(inInt2[1] & 0xFF);
                        this.bytesRead[7] = (byte)(inInt2[2] & 0xFF);
                        this.bytesRead[8] = (byte)(inInt2[3] & 0xFF);
                        this.bytesRead[9] = (byte)imgOrientation;
                        this.bytesRead[10] = (byte)imgFormat;
                        for (i = 0; i < fnameCharArray.length; ++i) {
                            this.bytesRead[i + 11] = (byte)fnameCharArray[i];
                        }
                        this.bytesRead[1] = (byte)(i + 6 & 0xFF);
                        this.bytesRead[2] = 0;
                        this.bytesRead[3] = 0;
                        this.bytesRead[4] = 0;
                        boolean done = false;
                        total = 0;
                        inChar = '\u0000';
                        int imgLength = msgLen - 6;
                        fOutStream = new FileOutputStream("ps" + imageID + ".jpg");
                        while (!done) {
                            if (imgLength - total >= 16384) {
                                inChar = (char)in.read(fBuff, 0, 16384);
                            } else if (imgLength - total > 0) {
                                inChar = (char)in.read(fBuff, 0, imgLength - total);
                            }
                            for (i = 0; i < inChar; ++i) {
                                DLSTCPIPPort.tBuff[i] = (byte)fBuff[i];
                            }
                            fOutStream.write(tBuff, 0, inChar);
                            if ((total += inChar) < imgLength) continue;
                            done = true;
                        }
                        fOutStream.close();
                        inState = stEnum.ST_IDLE;
                        fOutStream = null;
                    } else {
                        in.read(inInt, 0, 4);
                        msgLen = inInt[0];
                        msgLen = 256 * msgLen + inInt[1];
                        msgLen = 256 * msgLen + inInt[2];
                        msgLen = 256 * msgLen + inInt[3];
                        this.inCharArray = new char[msgLen];
                        in.read(this.inCharArray, 0, msgLen);
                        this.bytesRead = new byte[msgLen * 2 + 10];
                        this.bytesRead[0] = (byte)(inChar & 0xFF);
                        this.bytesRead[1] = (byte)(inInt[0] & 0xFF);
                        this.bytesRead[2] = (byte)(inInt[1] & 0xFF);
                        this.bytesRead[3] = (byte)(inInt[2] & 0xFF);
                        this.bytesRead[4] = (byte)(inInt[3] & 0xFF);
                        for (i = 0; i < msgLen; ++i) {
                            this.bytesRead[i + 5] = (byte)(this.inCharArray[i] & 0xFF);
                        }
                        for (i = 0; i < msgLen * 2; ++i) {
                            this.logData = this.logData + " 0x" + Integer.toHexString(this.bytesRead[i] & 0xFF);
                            if (i > 50) break;
                        }
                    }
                    this.log.trace(this, "bytes received[" + msgLen * 2 + "]" + this.logData);
                    this.fireDataReceivedEvent(this.bytesRead, msgLen * 2);
                }
            }
            catch (IOException e) {
                System.out.println("RXe: " + e);
                continue;
            }
            break;
        }
    }

    public void tcpRead() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            int numBytes = 0;
            while (this.inputStream.available() > 0) {
                numBytes = this.inputStream.read(this.readBuffer);
                bs.write(this.readBuffer, 0, numBytes);
            }
            byte[] bytesRead = bs.toByteArray();
            this.logData = "";
            for (int i = 0; i < bytesRead.length; ++i) {
                this.logData = this.logData + " 0x" + Integer.toHexString(bytesRead[i] & 0xFF);
                if (i > 50) break;
            }
            this.log.trace(this, "bytes received[" + bytesRead.length + "]" + this.logData);
            this.fireDataReceivedEvent(bytesRead, bytesRead.length);
        }
        catch (IOException e) {
            this.log.error(this, "IOException: " + e.getMessage());
        }
    }

    public void changeBaudRate(int nBaud) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stopLiveWeight() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static byte[] setIPAddress(String str) {
        String[] ipSplit = new String[5];
        byte[] lIPAddr = new byte[10];
        ipSplit = str.split("\\x2E");
        int temp = Integer.valueOf(ipSplit[0]);
        lIPAddr[0] = (byte)temp;
        temp = Integer.valueOf(ipSplit[1]);
        lIPAddr[1] = (byte)temp;
        temp = Integer.valueOf(ipSplit[2]);
        lIPAddr[2] = (byte)temp;
        temp = Integer.valueOf(ipSplit[3]);
        lIPAddr[3] = (byte)temp;
        return lIPAddr;
    }

    protected void startup() {
        hostThreadRunning = false;
        tcpipT = new tcpipThread();
        tcpipT.start();
    }

    static {
        out = null;
        in = null;
        inState = stEnum.ST_IDLE;
        fBuff = new char[16384];
        tBuff = new byte[16384];
        hostConnected = false;
        htpEnable = (byte)101;
        htpDisable = (byte)100;
        htpConnected = (byte)97;
        htpTest = (byte)84;
        htpConnectedData = "\u0003013\fJadeTest:1.0";
        logFileName = "ps-log.txt";
        logFile = null;
        loggingEnabled = false;
        saveImageFiles = false;
        inInt = new char[4];
        inInt2 = new char[4];
        extraMsgType = new int[6];
        extraMsgNum = new int[6];
    }

    public class tcpipThread
    extends Thread {
        public void run() {
            DLSTCPIPPort.this.hostGetAll();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class stEnum
    extends Enum<stEnum> {
        public static final stEnum ST_IDLE = new stEnum("ST_IDLE", 0);
        public static final stEnum ST_SIG1 = new stEnum("ST_SIG1", 1);
        public static final stEnum ST_ACK = new stEnum("ST_ACK", 2);
        public static final stEnum ST_ITEM = new stEnum("ST_ITEM", 3);
        public static final stEnum ST_PIC = new stEnum("ST_PIC", 4);
        public static final stEnum ST_LABEL = new stEnum("ST_LABEL", 5);
        public static final stEnum ST_LOC = new stEnum("ST_LOC", 6);
        public static final stEnum ST_VOL = new stEnum("ST_VOL", 7);
        public static final stEnum ST_TRACKING = new stEnum("ST_TRACKING", 8);
        public static final stEnum ST_FAULT = new stEnum("ST_FAULT", 9);
        public static final stEnum ST_CONNECTED = new stEnum("ST_CONNECTED", 10);
        public static final stEnum ST_UPDATE_ITEM = new stEnum("ST_UPDATE_ITEM", 11);
        public static final stEnum ST_LABEL_CHOICE = new stEnum("ST_LABEL_CHOICE", 12);
        public static final stEnum ST_OTHER = new stEnum("ST_OTHER", 13);
        private static final /* synthetic */ stEnum[] $VALUES;

        public static stEnum[] values() {
            return (stEnum[])$VALUES.clone();
        }

        public static stEnum valueOf(String name) {
            return (stEnum)((Object)Enum.valueOf(class$com$dls$jpos$transport$DLSTCPIPPort$stEnum == null ? (class$com$dls$jpos$transport$DLSTCPIPPort$stEnum = DLSTCPIPPort.class$("com.dls.jpos.transport.DLSTCPIPPort$stEnum")) : class$com$dls$jpos$transport$DLSTCPIPPort$stEnum, name));
        }

        private stEnum() {
        }

        static {
            $VALUES = new stEnum[]{ST_IDLE, ST_SIG1, ST_ACK, ST_ITEM, ST_PIC, ST_LABEL, ST_LOC, ST_VOL, ST_TRACKING, ST_FAULT, ST_CONNECTED, ST_UPDATE_ITEM, ST_LABEL_CHOICE, ST_OTHER};
        }
    }
}

