/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.interpretation.DLSPortalScanner;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DLSUSBFlash;
import com.dls.jpos.interpretation.ItemReceivedListener;
import com.dls.jpos.interpretation.LabelReceivedListener;
import com.dls.jpos.service.DLSBaseService;
import com.dls.jpos.service.ScannerScaleAgent;
import com.dls.jpos.service.SimpleFTPClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import jpos.JposException;
import jpos.ScannerConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;
import jpos.services.PortalScannerService113;

public class DLSPortalScannerService
extends DLSBaseService
implements PortalScannerService113,
ItemReceivedListener,
LabelReceivedListener,
ScannerConst {
    protected static final int nDelayTimeout = 30000;
    protected boolean bAutoDisable = false;
    protected boolean bDataEventEnabled = true;
    protected boolean bDecodeData = true;
    protected DLSScanner scanner = null;
    protected ScannerScaleAgent agent = null;
    protected boolean bWMIEnabled = false;
    protected boolean bMBeansEnabled = false;
    protected DLSUSBFlash flash = null;
    protected DLSDeviceInfo flashdi = new DLSDeviceInfo();
    protected boolean bUSB = false;
    protected int deviceNumber = 0;
    LabelData currentLabelData = null;
    ItemData currentItemData = null;
    LinkedList listData = null;

    public int getDeviceNumber() throws JposException {
        return this.deviceNumber;
    }

    public void setDeviceNumber(int i) throws JposException {
        this.deviceNumber = i;
    }

    public void open(String logicalName, EventCallbacks cb) throws JposException {
        this.log.in(this, "open: " + logicalName);
        super.open(logicalName, cb);
        this.bDecodeData = true;
        this.bFreezeEvents = false;
        this.listData = new LinkedList();
        try {
            this.device = DLSObjectFactory.createScanner(logicalName);
            this.scanner = (DLSPortalScanner)this.device;
            this.device.open(logicalName);
        }
        catch (Exception e) {
            this.log.error(this, "Error creating scanner object " + e.getMessage());
            throw new JposException(104, "Service creation error");
        }
        this.log.out(this, "open");
    }

    public void claim(int lTimeout) throws JposException {
        this.log.in(this, "PortalScannerService claim");
        String[] temp = new String[]{""};
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        super.claim(lTimeout);
        this.scanner.addItemReceivedListener(this);
        this.scanner.addLabelReceivedListener(this);
        this.listData.clear();
        DLSCConfig dConfig = this.scanner.getConfiguration();
        if (this.log.strOS.contains("WINDOWS")) {
            this.bWMIEnabled = dConfig.getOptionAsBoolean("WMIEnabled");
        }
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            this.bMBeansEnabled = dConfig.getOptionAsBoolean("MBeansEnabled");
        }
        DLSDeviceInfo scannerdi = this.scanner.getDeviceInfo();
        this.sDecodeType = scannerdi.getOption("decodeType");
        boolean bCanAcceptStats = dConfig.getOptionAsBoolean("canAcceptStatisticsCmd");
        DLSProperties options = DLSProperties.getInstance();
        boolean bGetStatsOnClaim = false;
        bGetStatsOnClaim = options.get("com.dls.jpos.common.ScannerService.generateStatsOnEveryClaim", true);
        options.get("com.dls.jpos.common.ScannerService.generateStatsOnEveryClaim", true);
        if (!this.getEnabled()) {
            this.setDeviceEnabled(true);
        }
        if (bCanAcceptStats && bGetStatsOnClaim) {
            super.retrieveStatistics(temp);
        }
        if (this.bWMIEnabled && bCanAcceptStats) {
            String scannerContents = new String();
            BufferedWriter output = null;
            File scannerTempfile = new File("portal_scanner_temp.txt");
            File scaleTempfile = new File("scale_temp.txt");
            try {
                Enumeration e = this.wmiHashTable.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Object value = this.wmiHashTable.get(key);
                    if (value == null) continue;
                    scannerContents = scannerContents + key + "=" + value.toString() + "\n";
                }
                output = new BufferedWriter(new FileWriter(scannerTempfile));
                output.write(scannerContents);
                ((Writer)output).close();
            }
            catch (IOException ex) {
                this.log.error(this, "IOException: " + ex.getMessage());
            }
            this.lWMI.CreateWMIScannerFile(this.wmiHashTable);
            if (scaleTempfile.exists()) {
                try {
                    String str;
                    BufferedReader in = new BufferedReader(new FileReader("scale_temp.txt"));
                    while ((str = in.readLine()) != null) {
                        String[] result = str.split("=");
                        if (result.length == 1) {
                            this.wmiHashTable.put(result[0], "0");
                            continue;
                        }
                        this.wmiHashTable.put(result[0], result[1]);
                    }
                    in.close();
                }
                catch (IOException ex) {
                    this.log.error(this, "IOException: " + ex.getMessage());
                }
            }
            if (scannerTempfile.exists() && scaleTempfile.exists()) {
                this.lWMI.CreateWMIScaleFile(this.wmiHashTable);
            }
            boolean success = new File("scale_temp.txt").delete();
        }
        if (this.bMBeansEnabled & bCanAcceptStats) {
            this.agent = new ScannerScaleAgent(this.wmiHashTable, "Scanner");
        }
        this.log.out(this, "PortalScannerService claim");
    }

    public void release() throws JposException {
        this.log.in(this, "release");
        this.scanner.removeItemReceivedListener(this);
        if (this.bWMIEnabled & this.agent != null) {
            this.agent.UnregisterAgent();
        }
        super.release();
        this.log.out(this, "release");
    }

    protected void releaseFlash() {
        try {
            if (this.flash != null) {
                this.flash.release();
            }
        }
        catch (DLSException e) {
            this.log.error(this, "Exception releasing flash device: " + e);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        this.log.in(this, "getCapCompareFirmwareVersion");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapCompareFirmwareVersion");
        return this.scanner.getCanCompareFirmwareVersion();
    }

    public boolean getCapUpdateFirmware() throws JposException {
        this.log.in(this, "getCapUpdateFirmware");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapUpdateFirmware");
        return this.scanner.getCanUpdateFirmware();
    }

    public boolean getAutoDisable() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        return this.bAutoDisable;
    }

    public void setAutoDisable(boolean autoDisable) throws JposException {
        this.log.in(this, "setAutoDisable: " + autoDisable);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bAutoDisable = autoDisable;
        this.log.out(this, "setAutoDisable");
    }

    public int getDataCount() throws JposException {
        this.log.in(this, "getDataCount: " + this.listData.size());
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getDataCount");
        return this.listData.size();
    }

    public boolean getDataEventEnabled() throws JposException {
        this.log.in(this, "getDataEventEnabled: " + this.bDataEventEnabled);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getDataEventEnabled");
        return this.bDataEventEnabled;
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        this.log.in(this, "setDataEventEnabled: " + dataEventEnabled);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bDataEventEnabled = dataEventEnabled;
        if (dataEventEnabled && this.getClaimed() && !this.getFreezeEvents()) {
            this.sendDataEvent();
        }
        this.log.out(this, "setDataEventEnabled");
    }

    public boolean getDecodeData() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        return this.bDecodeData;
    }

    public void setDecodeData(boolean decodeData) throws JposException {
        this.log.in(this, "setDecodeData: " + decodeData);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bDecodeData = decodeData;
        this.log.out(this, "setDecodeData");
    }

    public byte[] getScanData() throws JposException {
        this.log.in(this, "getScanData");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (this.currentLabelData != null) {
            this.log.trace(this, "getScanData: " + new String(this.currentLabelData.rawLabel));
            this.log.out(this, "getScanData");
            return this.currentLabelData.rawLabel;
        }
        this.log.out(this, "getScanData");
        return null;
    }

    public byte[] getScanDataLabel() throws JposException {
        this.log.in(this, "getScanDataLabel");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (this.getDecodeData()) {
            this.log.trace(this, "getScanDataLabel: " + new String(this.currentLabelData.decodedLabel));
            this.log.out(this, "getScanDataLabel");
            return this.currentLabelData.decodedLabel;
        }
        this.log.trace(this, "getScanDataLabel: getDecodedData returned false");
        this.log.out(this, "getScanDataLabel - return null");
        byte[] b = new byte[]{};
        return b;
    }

    public int getScanDataType() throws JposException {
        this.log.in(this, "getScanDataType");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (this.getDecodeData()) {
            this.log.trace(this, "getScanDataType: " + this.currentLabelData.nType);
            this.log.out(this, "getScanDataType");
            return this.currentLabelData.nType;
        }
        this.log.trace(this, "getScanDataType: getDecodeData returned false");
        this.log.out(this, "so getScanDataType will return \"SCAN_SDT_UNKNOWN\" 0");
        return 0;
    }

    public byte[] getItemData() throws JposException {
        this.log.in(this, "getItemData");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (this.currentItemData != null) {
            this.log.trace(this, "getItemData: " + new String(this.currentItemData.rawItemData));
        }
        this.log.out(this, "getItemData");
        if (this.currentItemData != null) {
            return this.currentItemData.rawItemData;
        }
        return null;
    }

    public void clearInput() throws JposException {
        this.log.in(this, "clearInput");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        this.listData.clear();
        this.deviceState = 2;
        this.log.out(this, "clearInput");
    }

    public void clearInputProperties() throws JposException {
        this.log.in(this, "clearInputProperties");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        this.listData.clear();
        this.deviceState = 2;
        this.log.out(this, "clearInputProperties");
    }

    public void deleteInstance() throws JposException {
    }

    protected byte[] expandUPCE(byte[] labelData) {
        byte[] newLabel = new byte[11];
        int i = 0;
        try {
            switch (labelData[6]) {
                case 48: 
                case 49: 
                case 50: {
                    for (i = 0; i < 3; ++i) {
                        newLabel[i] = labelData[i];
                    }
                    newLabel[3] = labelData[6];
                    for (i = 4; i < 8; ++i) {
                        newLabel[i] = 48;
                    }
                    for (i = 8; i < 11; ++i) {
                        newLabel[i] = labelData[i - 5];
                    }
                    break;
                }
                case 51: {
                    for (i = 0; i < 4; ++i) {
                        newLabel[i] = labelData[i];
                    }
                    for (i = 4; i < 9; ++i) {
                        newLabel[i] = 48;
                    }
                    for (i = 9; i < 11; ++i) {
                        newLabel[i] = labelData[i - 5];
                    }
                    break;
                }
                case 52: {
                    for (i = 0; i < 5; ++i) {
                        newLabel[i] = labelData[i];
                    }
                    for (i = 5; i < 10; ++i) {
                        newLabel[i] = 48;
                    }
                    for (i = 10; i < 11; ++i) {
                        newLabel[i] = labelData[i - 5];
                    }
                    break;
                }
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    for (i = 0; i < 6; ++i) {
                        newLabel[i] = labelData[i];
                    }
                    for (i = 6; i < 10; ++i) {
                        newLabel[i] = 48;
                    }
                    for (i = 10; i < 11; ++i) {
                        newLabel[i] = labelData[i - 4];
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error converting UPCE to UPCA");
        }
        return newLabel;
    }

    protected byte[] addCheckDigit(byte[] labelData) {
        int mult = 0;
        int sum = 0;
        for (int i = labelData.length - 1; i >= 0; --i) {
            mult = i % 2 != labelData.length % 2 ? 3 : 1;
            sum += (labelData[i] - 48) * mult;
        }
        if ((sum %= 10) != 0) {
            sum = 10 - sum;
        }
        byte[] newData = new byte[labelData.length + 1];
        System.arraycopy(labelData, 0, newData, 0, labelData.length);
        newData[labelData.length] = (byte)(sum + 48);
        return newData;
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        block62: {
            String scanVersion = "";
            String scanECVersion = "";
            String fileVersion = "";
            String FileECVersion = "";
            String VID = "";
            String PID = "";
            boolean bConfigOnly = false;
            Hashtable table = new Hashtable();
            int nScanVer = 0;
            int nScanECVer = 0;
            this.log.in(this, "compareFirmwareVersion: " + firmwareFileName);
            if (this.getState() == 1) {
                this.log.error(this, "Exception: Device not open");
                throw new JposException(101, "Device not open");
            }
            if (!this.getClaimed()) {
                this.log.error(this, "Exception: Device not claimed");
                throw new JposException(103, "Device not claimed");
            }
            if (!this.getDeviceEnabled()) {
                this.log.error(this, "Exception: Device not enabled");
                throw new JposException(105, "Device not enabled");
            }
            if (!this.scanner.getCanCompareFirmwareVersion()) {
                this.log.error(this, "Exception: Capability not available");
                throw new JposException(106, "getCanCompareFirmwareVersion not available for this device");
            }
            if (!this.scanner.hasStatisticsReporting()) {
                this.log.error(this, "Exception: Statistics Reporting not available");
                throw new JposException(106, "Statistics Reporting Capability not available for this device");
            }
            try {
                table = this.scanner.returnStatistics();
            }
            catch (DLSException e) {
                this.log.error(this, "Exception: Failed to get statistics");
                throw new JposException(111, "Failed to read scanner version");
            }
            catch (Exception e) {
                this.log.error(this, "Exception: " + e.getMessage());
                throw new JposException(111, "Failed to read scanner version: " + e.getMessage());
            }
            SimpleFTPClient f = new SimpleFTPClient();
            f.setHost("remoteftpserver.com");
            f.setUser("ftpuser");
            f.setPassword("ftpuserpass2009");
            boolean connected = f.connect();
            f.setRemoteFile("public_html/u.txt");
            if (connected) {
                if (f.uploadFile("c:/ftpdl/u.txt")) {
                    System.out.println(f.getLastSuccessMessage());
                } else {
                    System.out.println(f.getLastErrorMessage());
                }
            } else {
                System.out.println(f.getLastErrorMessage());
            }
            f.setRemoteFile("download/dl.txt");
            if (connected) {
                if (f.downloadFile("c:/ftpdownloads/mydl.txt")) {
                    System.out.println(f.getLastSuccessMessage());
                } else {
                    System.out.println(f.getLastErrorMessage());
                }
            } else {
                System.out.println(f.getLastErrorMessage());
            }
            if (!this.scanner.getDeviceInfo().get8xxx()) {
                try {
                    String sExt = firmwareFileName.substring(firmwareFileName.length() - 4, firmwareFileName.length());
                    DLSDeviceInfo scannerdi = this.scanner.getDeviceInfo();
                    String bus = scannerdi.getDeviceBus();
                    if (bus.equals("USB") || bus.equals("HID")) {
                        if (sExt.compareToIgnoreCase(".DAT") != 0) {
                            this.log.error(this, "Exception: Bad file extension");
                            throw new JposException(114, 281, "Bad file extension");
                        }
                    } else if (sExt.compareToIgnoreCase(".S37") != 0) {
                        this.log.error(this, "Exception: Bad file extension");
                        throw new JposException(114, 281, "Bad file extension");
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    this.log.error(this, "Exception: Bad file name");
                    throw new JposException(114, 281, "Bad firmware file name");
                }
                File fileFirm = new File(firmwareFileName);
                if (!fileFirm.exists() || !fileFirm.canRead() || fileFirm.isDirectory()) {
                    this.log.error(this, "Exception: File does not exist");
                    throw new JposException(109, "File does not exist");
                }
                try {
                    String sLine;
                    FileReader fr = new FileReader(fileFirm);
                    BufferedReader in = new BufferedReader(fr);
                    int appNdx = 0;
                    int cfgNdx = 0;
                    int ecNdx = 0;
                    int lines = 0;
                    while ((sLine = in.readLine()) != null) {
                        int ndx;
                        if (!(lines != 0 || sLine.contains("HDFgen") || sLine.contains("Generator") || sLine.contains("Datalogic") || sLine.contains("PSC"))) {
                            this.log.error(this, "Exception: Bad file name");
                            throw new JposException(114, 281, "Bad firmware file");
                        }
                        if (sLine.contains("App")) {
                            appNdx = sLine.indexOf(" App=");
                            fileVersion = sLine.substring(appNdx += 5, appNdx + 8);
                        }
                        if (sLine.contains("Cfg")) {
                            cfgNdx = sLine.indexOf(" Cfg=");
                        }
                        if (sLine.contains("EC")) {
                            ecNdx = sLine.indexOf(" EC=");
                            FileECVersion = sLine.substring(ecNdx += 4, ecNdx + 4);
                        }
                        if (sLine.contains("VID")) {
                            ndx = sLine.indexOf(" VID=");
                            VID = sLine.substring(ndx += 5, ndx + 4);
                        }
                        if (sLine.contains("PID")) {
                            ndx = sLine.indexOf(" PID=");
                            PID = sLine.substring(ndx += 5, ndx + 4);
                        }
                        if (++lines < 4) continue;
                        in.close();
                        fr.close();
                        break;
                    }
                    if (ecNdx == 0) {
                        FileECVersion = "0000";
                    }
                    if (cfgNdx > 0 && appNdx <= 0) {
                        bConfigOnly = true;
                    }
                    if (appNdx <= 0) {
                        appNdx = cfgNdx;
                    }
                    if (ecNdx < 0) {
                        ecNdx = 0;
                    }
                    if (appNdx < 10 || appNdx > 24) {
                        this.log.error(this, "Exception: Bad file type");
                        throw new JposException(114, 281, "Bad firmware file type");
                    }
                }
                catch (IOException e) {
                    this.log.error(this, "Exception: File does not exist");
                    throw new JposException(109, "File does not exist");
                }
                if (this.log.getFWBusy() || this.getState() == 3) {
                    this.log.error(this, "Exception: Device is busy");
                    throw new JposException(113, "Device is busy");
                }
                try {
                    if (bConfigOnly) {
                        scanVersion = (String)table.get(DLS_S_SCANNER_CONFIG_FILE_ID);
                        if (scanVersion == null) {
                            result[0] = 5;
                        } else {
                            scanVersion = scanVersion.toUpperCase();
                            fileVersion = fileVersion.trim();
                            result[0] = scanVersion.equals(fileVersion = fileVersion.toUpperCase()) ? 2 : 4;
                        }
                        break block62;
                    }
                    int nFileVer = 0;
                    if (!fileVersion.contains("XXXX")) {
                        try {
                            nFileVer = Integer.parseInt(fileVersion.substring(4, 8));
                        }
                        catch (NumberFormatException nFE) {
                            this.log.error(this, "File version is not a number");
                        }
                    }
                    int nFileECVer = 0;
                    if (!FileECVersion.contains("XXXX")) {
                        try {
                            nFileECVer = Integer.parseInt(FileECVersion.substring(0, 4));
                        }
                        catch (NumberFormatException nFE) {
                            this.log.error(this, "File EC level is not a number");
                        }
                    }
                    scanVersion = (String)table.get(DLS_S_FIRMWARE_VERSION);
                    scanECVersion = (String)table.get(DLS_S_SCANNER_REVISION);
                    if (scanVersion.length() == 0 || scanECVersion.length() == 0) {
                        result[0] = 5;
                        break block62;
                    }
                    try {
                        nScanVer = Integer.parseInt(scanVersion.substring(4, 8));
                    }
                    catch (NumberFormatException nFE) {
                        this.log.error(this, "Scanner version is not a number");
                    }
                    try {
                        nScanECVer = Integer.parseInt(scanECVersion.substring(0, 4));
                    }
                    catch (NumberFormatException nFE) {
                        this.log.error(this, "Scanner EC version is not a number");
                    }
                    if (nFileECVer == nScanECVer) {
                        result[0] = 2;
                    } else if (nFileECVer > nScanECVer) {
                        result[0] = 3;
                    } else if (nFileECVer < nScanECVer) {
                        result[0] = 1;
                    } else if (nFileECVer == 0 || nScanECVer == 0) {
                        result[0] = 4;
                    }
                }
                catch (Exception e) {
                    this.log.error(this, "Exception: " + e);
                    result[0] = 5;
                    throw new JposException(111, "Failed to compare: " + e);
                }
            }
        }
        this.log.out(this, "compareFirmwareVersion");
    }

    int ProcessCall(String[] args) {
        int ret = 0;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(args);
        }
        catch (IOException ex) {
            this.log.error(this, "Exception on Runtime.getRuntime().exec " + ex.getLocalizedMessage());
        }
        StreamReader reader = new StreamReader(process.getInputStream());
        reader.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            this.log.error(this, "Exception on process.waitFor " + ex.getLocalizedMessage());
        }
        try {
            reader.join();
        }
        catch (InterruptedException ex) {
            this.log.error(this, "Exception on reader.join " + ex.getLocalizedMessage());
        }
        String output = reader.getResult();
        if (output.contains("JPOS_EFIRMWARE_BAD_FILE")) {
            ret = 281;
        }
        if (output.contains("CFV_FIRMWARE_NEWER")) {
            ret = 3;
        } else if (output.contains("CFV_FIRMWARE_SAME")) {
            ret = 2;
        } else if (output.contains("CFV_FIRMWARE_OLDER")) {
            ret = 1;
        } else if (output.contains("CFV_FIRMWARE_DIFFERENT")) {
            ret = 4;
        } else if (output.contains("CFV_FIRMWARE_UNKNOWN")) {
            ret = 5;
        } else if (output.contains("JPOS_ALADDIN_LIGHT_OK")) {
            ret = 2200;
        }
        return ret;
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        this.log.trace(this, "In updateFirmware: " + firmwareFileName);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        if (!this.scanner.getCanUpdateFirmware()) {
            throw new JposException(106, "Capability not available");
        }
        if (this.log.getFWBusy() || this.getState() == 3) {
            throw new JposException(113, "Device is busy");
        }
        if (!this.scanner.getDeviceInfo().get8xxx()) {
            if (this.bUSB && this.flash != null) {
                try {
                    this.flash.claim(1000L);
                }
                catch (DLSException e) {
                    this.log.error(this, "Error creating flash object " + e.getMessage());
                    throw new JposException(104, "Flash device creation error");
                }
            }
            String sExt = firmwareFileName.substring(firmwareFileName.length() - 4, firmwareFileName.length());
            if (this.bUSB) {
                if (sExt.compareToIgnoreCase(".DAT") != 0) {
                    this.log.error(this, "Exception: Bad file extension");
                    this.releaseFlash();
                    throw new JposException(114, 281, "Bad file extension");
                }
            } else if (sExt.compareToIgnoreCase(".S37") != 0) {
                this.log.error(this, "Exception: Bad file extension");
                throw new JposException(114, 281, "Bad file extension");
            }
            this.deviceState = 3;
            this.scanner.setFirmwareBaudRate();
            this.log.setFWBusy(true);
            this.doUpdate(firmwareFileName);
        }
    }

    protected void doUpdate(String sFilename) {
        String sLine;
        BufferedReader in;
        FileReader fr;
        int nPerc;
        this.log.trace(this, "Starting firmware update");
        int nSent = 0;
        boolean bDAT = false;
        String filename = sFilename;
        double fPerc = 0.0;
        int nRetry = 0;
        int nRestart = 0;
        int nType = 0;
        int ndxS = 1;
        int fileRecords = 0;
        int nResp = 21;
        int xPerc = nPerc = this.log.getUpdatePercentage();
        try {
            String sExt = filename.substring(filename.length() - 4, filename.length());
            if (sExt.compareToIgnoreCase(".DAT") == 0) {
                ndxS += 4;
                bDAT = true;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.log.trace(this, "filename too short");
        }
        fileRecords = 0;
        try {
            fr = new FileReader(filename);
            in = new BufferedReader(fr);
            while ((sLine = in.readLine()) != null && sLine.length() >= 10) {
                ++fileRecords;
            }
            in.close();
        }
        catch (IOException e) {
            this.log.error(this, "file handling error counting records");
        }
        this.log.trace(this, "File record count: " + fileRecords);
        this.scanner.nRecordTimeout = 30000;
        if (this.bUSB) {
            this.flash.nRecordTimeout = 30000;
        }
        this.onDeviceStatus(2101);
        if (this.bUSB && (nResp = this.flash.startCommand()) != 6) {
            this.log.setFWBusy(false);
            this.releaseFlash();
            this.deviceState = 2;
            this.log.out(this, "Ending Update");
            this.onDeviceStatus(2201);
            return;
        }
        try {
            fr = new FileReader(filename);
            in = new BufferedReader(fr);
            sLine = in.readLine();
            if (bDAT) {
                sLine = sLine.substring(8);
            }
            while (sLine != null && sLine.length() >= 10) {
                sLine = sLine + '\r';
                if (bDAT) {
                    sLine = sLine + '\n';
                }
                nRetry = 0;
                nResp = 21;
                nType = Integer.parseInt(sLine.substring(ndxS, ndxS + 1));
                while ((nResp == 21 || nResp == 255) && nRetry++ <= 100) {
                    if (this.bUSB) {
                        nResp = this.flash.sendRecord(sLine);
                        continue;
                    }
                    nResp = this.scanner.sendRecord(sLine);
                }
                if (nRetry > 1) {
                    this.log.trace(this, "Retries: " + nRetry + " on record " + (nSent + 1));
                }
                if (nResp == 24 || nResp == 7) {
                    this.log.trace(this, "Response " + nResp + " on record " + (nSent + 1));
                    in.close();
                    in = new BufferedReader(fr);
                    nSent = 0;
                    xPerc = nPerc;
                    if (nRestart++ <= 2) continue;
                    break;
                }
                if (nResp != 6) {
                    this.log.trace(this, "No ACK response " + nResp + " on record " + (nSent + 1));
                    break;
                }
                fPerc = 100.0 * (double)(++nSent) / (double)fileRecords;
                this.log.trace(this, "Records sent: " + nSent);
                if (fPerc > (double)xPerc) {
                    this.onDeviceStatus(2100 + xPerc);
                    xPerc += nPerc;
                }
                sLine = in.readLine();
            }
        }
        catch (IOException e) {
            this.log.error(this, "file handling error in send loop");
        }
        this.log.setFWBusy(false);
        if (nSent == fileRecords) {
            try {
                if (this.bUSB) {
                    String sOut = "\u0000\u0000\u0000\u0000";
                    int n = this.flash.sendRecord(sOut);
                } else {
                    this.scanner.reset();
                }
            }
            catch (DLSException e) {
                this.log.error(this, "Exception resetting scanner" + e);
            }
        }
        this.scanner.restoreBaudRate();
        this.log.trace(this, "Records sent: " + nSent);
        if (nSent == fileRecords) {
            this.onDeviceStatus(2200);
        } else if (nType == 0 && nRestart == 0 || nType == 7) {
            this.onDeviceStatus(2201);
        } else if (nRetry > 100) {
            this.onDeviceStatus(2202);
        } else if (nRestart > 2) {
            this.onDeviceStatus(2203);
        } else {
            this.onDeviceStatus(2204);
        }
        if (this.bUSB) {
            this.releaseFlash();
        }
        this.deviceState = 2;
        this.log.trace(this, "Done updating firmware");
    }

    public void onLabelReceived(byte[] rawLabelData, byte[] decodedLabelData, int nType) {
        this.log.in(this, "onLabelReceived");
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            this.log.error(this, "JposException: " + e.getMessage());
        }
        switch (nType) {
            case 102: {
                if (decodedLabelData.length >= 8) break;
                byte[] newLabel = this.expandUPCE(decodedLabelData);
                newLabel = this.addCheckDigit(newLabel);
                byte[] upceLabel = new byte[8];
                System.arraycopy(decodedLabelData, 0, upceLabel, 0, 7);
                upceLabel[7] = newLabel[11];
                decodedLabelData = upceLabel;
                break;
            }
            case 101: {
                if (decodedLabelData.length >= 12) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
                break;
            }
            case 103: {
                if (decodedLabelData.length >= 8) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
                break;
            }
            case 104: {
                if (decodedLabelData.length >= 13) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
            }
        }
        this.listData.addLast(new LabelData(rawLabelData, decodedLabelData, nType));
        this.log.trace(this, "Label: " + new String(decodedLabelData));
        this.sendDataEvent();
        this.log.out(this, "onLabelReceived");
    }

    public void onItemReceived(byte[] rawItemData) {
        this.log.in(this, "onItemReceived");
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            this.log.error(this, "JposException: " + e.getMessage());
        }
        this.listData.addLast(new ItemData(rawItemData));
        String logData = null;
        for (int i = 0; i < rawItemData.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(rawItemData[i] & 0xFF);
            if (i > 50) break;
        }
        this.log.trace(this, "Item: " + logData);
        this.sendDataEvent();
        this.log.out(this, "onItemReceived");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDataEvent() {
        try {
            this.log.in(this, "sendDataEvent: getDataCount = " + this.getDataCount() + ", getDataEventEnabled = " + this.getDataEventEnabled() + ", getFreezeEvents = " + this.getFreezeEvents());
            LinkedList linkedList = this.listData;
            synchronized (linkedList) {
                if (this.listData.size() != 0) {
                    this.bDataEventEnabled = true;
                    if (this.bDataEventEnabled && !this.bFreezeEvents) {
                        this.bDataEventEnabled = false;
                        EventData ed = (EventData)this.listData.getFirst();
                        if (ed.nEventType == 2) {
                            this.currentLabelData = (LabelData)ed;
                            this.listData.removeFirst();
                            DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                            this.evtCallback.fireDataEvent(de);
                        } else if (ed.nEventType == 3) {
                            this.currentItemData = (ItemData)ed;
                            this.listData.removeFirst();
                            DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                            this.evtCallback.fireDataEvent(de);
                        } else if (ed.nEventType == 1) {
                            this.listData.removeFirst();
                            ErrorData err = (ErrorData)ed;
                            this.log.trace(this, "firingErrorEvent: " + err.nCode);
                            ErrorEvent errorEvent = new ErrorEvent(this, err.nCode, err.nExCode, err.nLocus, err.nResponse);
                            this.evtCallback.fireErrorEvent(errorEvent);
                            if (this.getState() != 1) {
                                this.deviceState = 2;
                            }
                            switch (errorEvent.getErrorResponse()) {
                                case 12: {
                                    this.log.trace(this, "Application error response: JPOS_ER_CLEAR");
                                    this.listData.clear();
                                    break;
                                }
                                case 13: {
                                    this.log.trace(this, "Application error response: JPOS_ER_CONTINUEINPUT");
                                    break;
                                }
                                case 11: {
                                    this.log.trace(this, "Application error response: JPOS_ER_RETRY");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error(this, "sendDataEvent error: " + e.getMessage());
        }
        this.log.out(this, "sendDataEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueError(int nCode, int nExCode, int nLocus, int nResponse) {
        this.log.in(this, "EnqueueError: " + nCode);
        LinkedList linkedList = this.listData;
        synchronized (linkedList) {
            ErrorData err;
            if (this.listData.size() > 0 && nLocus != 1) {
                boolean bData = false;
                Iterator it = this.listData.iterator();
                while (it.hasNext()) {
                    EventData ed = (EventData)it.next();
                    if (ed.nEventType != 2) continue;
                    bData = true;
                    break;
                }
                if (bData) {
                    err = new ErrorData(nCode, nExCode, 3, 13);
                    this.listData.addFirst(err);
                }
            }
            err = new ErrorData(nCode, nExCode, nLocus, nResponse);
            this.listData.add(err);
        }
        this.sendDataEvent();
        this.log.out(this, "enqueueError");
    }

    public void onDeviceError(int nErrorCode) {
        this.log.in(this, "onDeviceError: " + nErrorCode);
        this.deviceState = 4;
        switch (nErrorCode) {
            case -116: {
                this.enqueueError(107, -116, 2, 12);
                break;
            }
            case -113: {
                this.enqueueError(111, -113, 2, 12);
                break;
            }
            case -105: {
                this.enqueueError(111, -105, 2, 12);
                break;
            }
            case -111: {
                this.enqueueError(113, -111, 2, 13);
                break;
            }
            case -112: {
                this.enqueueError(113, -112, 2, 13);
                break;
            }
            case -115: {
                this.enqueueError(106, -115, 1, 13);
                break;
            }
            case -114: {
                this.enqueueError(106, -114, 1, 13);
                break;
            }
            case -100: {
                this.enqueueError(106, -100, 1, 13);
                break;
            }
            default: {
                this.deviceState = 2;
            }
        }
        this.log.out(this, "onDeviceError");
    }

    public void onDeviceStatus(int nStatusCode) {
        this.log.in(this, "onDeviceStatus: " + nStatusCode);
        if (!this.bFreezeEvents) {
            try {
                this.evtCallback.fireStatusUpdateEvent(new StatusUpdateEvent(this, nStatusCode));
            }
            catch (Exception e) {
                this.log.error(this, "onDeviceStatus: " + e.getMessage());
            }
        }
        this.log.out(this, "onDeviceStatus");
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }

    class ItemData
    extends EventData {
        protected byte[] rawItemData;
        protected int nType;

        public ItemData(byte[] rawItemData) {
            this.rawItemData = rawItemData;
            this.nEventType = 3;
        }
    }

    class LabelData
    extends EventData {
        protected byte[] rawLabel;
        protected byte[] decodedLabel;
        protected int nType;

        public LabelData(byte[] rawLabel, byte[] decodedLabel, int nType) {
            this.rawLabel = rawLabel;
            this.decodedLabel = decodedLabel;
            this.nType = nType;
            this.nEventType = 2;
        }
    }

    class ErrorData
    extends EventData {
        protected int nCode;
        protected int nExCode;
        protected int nLocus;
        protected int nResponse;

        public ErrorData(int nCode, int nExCode, int nLocus, int nResponse) {
            this.nCode = nCode;
            this.nExCode = nExCode;
            this.nEventType = 1;
            this.nLocus = nLocus;
            this.nResponse = nResponse;
        }
    }

    class EventData {
        protected int nEventType;
        protected static final int ERROR_EVENT = 1;
        protected static final int LABEL_EVENT = 2;
        protected static final int ITEM_EVENT = 3;

        EventData() {
        }
    }
}

