/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.interpretation.DLSScale;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;

public class DLSVirtualUSBScale
extends DLSScale
implements DLSJposConst {
    protected static final byte[] performSelfTestCmd = new byte[]{0, 16, 0, 0, 0};
    protected static final byte[] statusRequestCmd = new byte[]{0, 32, 0, 0, 0};
    protected static final byte[] resetCmd = new byte[]{0, 64, 0, 0, 0};
    protected static final byte[] englishWeightCmd = new byte[]{1, 0, 0, 0, 0};
    protected static final byte[] metricWeightCmd = new byte[]{2, 0, 0, 0, 0};
    protected static final byte[] zeroScaleCmd = new byte[]{3, 0, 0, 0, 0};
    protected static final byte[] enable3ByteStatusCmd = new byte[]{4, 0, 0, 0, 0};
    protected static final byte[] disable3ByteStatusCmd = new byte[]{5, 0, 0, 0, 0};
    protected static final byte[] clearRemoteDisplayCmd = new byte[]{6, 0, 0, 0, 0};
    protected byte[] configureScaleCmd = new byte[]{32, 0, 0, 0, 0};
    protected static final byte[] reportScaleConfigCmd = new byte[]{33, 0, 0, 0, 0};
    protected static final int RESP_FIRMWARE_FLASH = 1;
    protected static final int RESP_CONFIG_DATA = 2;
    protected static final int RESP_XTEND_STATUS = 4;
    protected static final int RESP_CMD_ERROR = 64;
    protected static final int RESP_NOT_READY = 128;
    protected static final int RESP_METRIC = 256;
    protected static final int RESP_FIVE_DIGIT = 512;
    protected static final int RESP_NO_WEIGHT = 1024;
    protected static final int RESP_DATA_ERROR = 2048;
    protected static final int RESP_READ_ERROR = 4096;
    protected static final int RESP_NO_DISPLAY = 8192;
    protected static final int RESP_HARDWARE_ERROR = 16384;
    protected static final int RESP_CMD_REJECT = 32768;
    protected static final int RESP_CONFIG_SUCCESS = 65536;
    protected static final int RESP_UNDER_ZERO = 131072;
    protected static final int RESP_OVER_CAPACITY = 262144;
    protected static final int RESP_CENTER_OF_ZERO = 524288;
    protected static final int RESP_REQUIRES_ZEROING = 0x100000;
    protected static final int RESP_SCALE_WARMUP = 0x200000;
    protected static final int RESP_DUPLICATE_WEIGHT = 0x400000;
    private Object reportResp = new Object();
    private static final int reportTimeout = 2000;
    private Object updateResp = new Object();
    private static final int updateTimeout = 2000;
    private static final int statusTimeout = 2000;
    private Object statusResp = new Object();
    private static final int liveTimeout = 1000;
    private int nLiveResp = 0;
    private int nDevLiveWeight = 0;
    private byte[] dataBuf = null;
    private boolean bDeviceReady = false;
    private byte nStat1;
    private byte nStat2;
    private byte nStat3;
    private Object objStatus = new Object();
    private boolean bReattachPending = true;
    private boolean bGetWeight = false;
    private boolean bZeroValid = true;
    private boolean bDioCommand = false;
    public boolean bLiveWeight = false;

    protected void fireWeightEvent(int nResp, byte[] inBuf) {
        int digits = 4;
        if ((nResp & 0x200) == 512 || (nResp & 0x100) == 256) {
            digits = 5;
        }
        String strWeight = "";
        for (int i = 0; i < digits; ++i) {
            strWeight = strWeight + inBuf[i + 3];
        }
        int nWeight = Integer.parseInt(strWeight);
        if (digits == 4) {
            nWeight *= 10;
        }
        this.fireWeightReceivedEvent(nWeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enable3ByteStatus() {
        this.log.in(this, "enable3ByteStatus");
        if (this.log.getFWBusy()) {
            return;
        }
        try {
            Object object = this.statusResp;
            synchronized (object) {
                this.port.sendData(enable3ByteStatusCmd, enable3ByteStatusCmd.length);
                this.statusResp.wait(2000L);
            }
        }
        catch (Exception e) {
            this.log.error(this, "enable3ByteStatus: " + e.getMessage());
        }
        this.log.out(this, "enable3ByteStatus");
    }

    public void doSelfTest() {
        this.log.in(this, "performSelfTest");
        if (this.log.getFWBusy()) {
            this.log.error(this, "Firmware update in progress.");
            return;
        }
        this.port.sendData(performSelfTestCmd, performSelfTestCmd.length);
        this.log.out(this, "performSelfTest");
    }

    public boolean doHealthCheck() {
        return this.isAlive();
    }

    public DLSCConfig getConfiguration() {
        return this.scaleConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        if (this.log.getFWBusy()) {
            return false;
        }
        boolean bRc = true;
        Object object = this.statusResp;
        synchronized (object) {
            this.bDeviceReady = false;
            this.port.sendData(statusRequestCmd, statusRequestCmd.length);
            try {
                this.statusResp.wait(this.nTimeout);
                bRc = this.bDeviceReady;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bRc;
    }

    public void enable() throws DLSException {
        this.log.in(this, "enable");
        if (this.log.getFWBusy()) {
            this.log.error(this, "Firmware update in progress.");
            return;
        }
        if (this.getStatusNotify() == 2) {
            if (this.log.getFWBusy()) {
                return;
            }
            if (this.bLiveWeight) {
                return;
            }
            this.bLiveWeight = this.getMetricMode() ? this.port.startLiveWeight(metricWeightCmd, metricWeightCmd.length, this.getPollRate()) : this.port.startLiveWeight(englishWeightCmd, englishWeightCmd.length, this.getPollRate());
        }
        this.log.out(this, "enable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws DLSException {
        this.log.in(this, "disable");
        Object object = this.objStatus;
        synchronized (object) {
            this.port.stopLiveWeight();
            this.bLiveWeight = false;
        }
        this.log.out(this, "disable");
    }

    public void setStatusNotify(int nValue) {
        if (this.nStatusNotify != nValue) {
            this.port.stopLiveWeight();
            this.bLiveWeight = false;
        }
        this.nStatusNotify = nValue;
    }

    public void setMetricMode(boolean bValue) {
        this.log.in(this, "setMetricMode: " + bValue);
        this.bMetricMode = bValue;
        this.scaleConfig.setMetricWeightMode(bValue);
        try {
            this.updateConfiguration();
        }
        catch (DLSException e) {
            this.log.error(this, e.getMessage());
        }
        this.log.out(this, "setMetricMode");
    }

    public void clearDisplay() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(clearRemoteDisplayCmd, clearRemoteDisplayCmd.length);
    }

    public void zeroScale() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(zeroScaleCmd, zeroScaleCmd.length);
    }

    public boolean canZeroScale() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration() throws DLSException {
        this.log.in(this, "updateConfiguration");
        this.log.trace(this, " #---# displayRequired: ..... " + this.scaleConfig.getDisplayRequired());
        this.log.trace(this, " #---# enforceZeroReturn: ... " + this.scaleConfig.getEnforceZeroReturn());
        this.log.trace(this, " #---# fiveDigitWeight: ..... " + this.scaleConfig.getFiveDigitWeight());
        this.log.trace(this, " #---# indicateZeroWithLED .. " + this.scaleConfig.getIndicateZeroWithLED());
        this.log.trace(this, " #---# metricWeightMode ..... " + this.scaleConfig.getMetricWeightMode());
        this.log.trace(this, " #---# operationMode ........ " + this.scaleConfig.getOperationMode());
        this.log.trace(this, " #---# vibrationSensitivity . " + this.scaleConfig.getVibrationSensitivity());
        this.log.trace(this, " #---# zeroValid ............ " + this.scaleConfig.getZeroValid());
        byte cfg0 = 0;
        byte cfg1 = 0;
        byte cfg2 = 0;
        if (this.scaleConfig.getOperationMode() != 0) {
            cfg0 = (byte)(cfg0 | 1);
        }
        if (this.scaleConfig.getDisplayRequired()) {
            cfg0 = (byte)(cfg0 | 4);
        }
        if (this.scaleConfig.getIndicateZeroWithLED()) {
            cfg0 = (byte)(cfg0 | 8);
        }
        if (this.scaleConfig.getMetricWeightMode()) {
            cfg0 = (byte)(cfg0 | 0x10);
        }
        if (this.scaleConfig.getEnforceZeroReturn()) {
            cfg0 = (byte)(cfg0 | 0x20);
        }
        if (this.scaleConfig.getVibrationSensitivity() < 4) {
            cfg0 = (byte)(cfg0 | this.scaleConfig.getVibrationSensitivity() << 6);
        }
        if (this.scaleConfig.getFiveDigitWeight()) {
            cfg1 = (byte)(cfg1 | 1);
        }
        this.configureScaleCmd[2] = cfg0;
        this.configureScaleCmd[3] = cfg1;
        this.configureScaleCmd[4] = cfg2;
        this.bZeroValid = this.scaleConfig.getZeroValid();
        if (this.log.getFWBusy()) {
            return;
        }
        Object object = this.updateResp;
        synchronized (object) {
            this.dataBuf = null;
            this.port.sendData(this.configureScaleCmd, this.configureScaleCmd.length);
            try {
                this.updateResp.wait(2000L);
                if (this.dataBuf != null) {
                    this.waitForReady();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.log.out(this, "updateConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportConfiguration() throws DLSException {
        this.log.in(this, "reportConfiguration");
        if (this.log.getFWBusy()) {
            return;
        }
        Object object = this.reportResp;
        synchronized (object) {
            this.port.sendData(reportScaleConfigCmd, reportScaleConfigCmd.length);
            try {
                this.dataBuf = null;
                this.reportResp.wait(this.nTimeout);
                if (this.dataBuf != null) {
                    DLSScaleConfig sConfig = new DLSScaleConfig();
                    sConfig.setOperationMode(this.dataBuf[3] & 3);
                    sConfig.setDisplayRequired((this.dataBuf[3] & 4) == 4);
                    sConfig.setIndicateZeroWithLED((this.dataBuf[3] & 8) == 8);
                    sConfig.setMetricWeightMode((this.dataBuf[3] & 0x10) == 16);
                    sConfig.setEnforceZeroReturn((this.dataBuf[3] & 0x20) == 32);
                    sConfig.setVibrationSensitivity((this.dataBuf[3] & 0xC0) >> 6);
                    sConfig.setFiveDigitWeight((this.dataBuf[4] & 1) == 1);
                    this.bZeroValid = this.scaleConfig.getZeroValid();
                    this.log.trace(this, " #+++# displayRequired: ..... " + sConfig.getDisplayRequired());
                    this.log.trace(this, " #+++# enforceZeroReturn: ... " + sConfig.getEnforceZeroReturn());
                    this.log.trace(this, " #+++# fiveDigitWeight: ..... " + sConfig.getFiveDigitWeight());
                    this.log.trace(this, " #+++# indicateZeroWithLED .. " + sConfig.getIndicateZeroWithLED());
                    this.log.trace(this, " #+++# metricWeightMode ..... " + sConfig.getMetricWeightMode());
                    this.log.trace(this, " #+++# operationMode ........ " + sConfig.getOperationMode());
                    this.log.trace(this, " #+++# vibrationSensitivity . " + this.scaleConfig.getVibrationSensitivity());
                    this.log.trace(this, " #+++# zeroValid ............ " + this.scaleConfig.getZeroValid());
                }
            }
            catch (InterruptedException e) {
                this.log.error(this, e.getMessage());
            }
        }
        this.log.out(this, "reportConfiguration");
    }

    public void reset() throws DLSException {
        this.bReattachPending = true;
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(resetCmd, resetCmd.length);
    }

    public void readMetricWeight() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.bGetWeight = true;
        this.port.sendData(metricWeightCmd, metricWeightCmd.length);
    }

    public void readEnglishWeight() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.bGetWeight = true;
        this.port.sendData(englishWeightCmd, englishWeightCmd.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReady() {
        int loops = 5;
        long lTimeout = 500L;
        this.bDeviceReady = false;
        if (this.log.getFWBusy()) {
            return;
        }
        while (loops-- > 0 && !this.bDeviceReady) {
            try {
                Object object = this.statusResp;
                synchronized (object) {
                    this.port.sendData(statusRequestCmd, statusRequestCmd.length);
                    this.statusResp.wait(lTimeout);
                }
            }
            catch (Exception e) {
                this.log.error(this, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readStatusWeight() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        if (!this.isLiveWeight()) {
            return;
        }
        int nCurStatus = 0;
        int nCurWeight = 0;
        Object object = this.objStatus;
        synchronized (object) {
            this.nDevLiveWeight = -1;
            this.nLiveResp = 0;
            if (this.getMetricMode()) {
                this.port.sendData(metricWeightCmd, metricWeightCmd.length);
            } else {
                this.port.sendData(englishWeightCmd, englishWeightCmd.length);
            }
            try {
                this.objStatus.wait(1000L);
            }
            catch (InterruptedException e) {
                throw new DLSException(-2147483640, "readStatusWeight interrupted.");
            }
            if (!this.isLiveWeight()) {
                return;
            }
            if (this.nDevLiveWeight < 0) {
                throw new DLSException(-2147483640, "readStatusWeight timeout");
            }
            nCurWeight = this.nDevLiveWeight;
            nCurStatus = (this.nLiveResp & 0x80) == 128 ? 15 : ((this.nLiveResp & 0x400) == 1024 ? 12 : ((this.nLiveResp & 0x20000) == 131072 ? 16 : ((this.nLiveResp & 0x40000) == 262144 ? 14 : ((this.nLiveResp & 0x80000) == 524288 ? 13 : 11))));
        }
        if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
            this.setStatusValue(nCurStatus);
            if (nCurStatus == 11 || nCurStatus == 13) {
                this.setLiveWeight(nCurWeight);
            }
            if (this.isLiveWeight()) {
                this.onStatusUpdate(nCurStatus);
            }
        }
    }

    public void onStatusUpdate(int nStatus) {
        this.fireDeviceStatusEvent(nStatus);
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void onDeviceAdded() {
    }

    public void onDeviceReattached() {
        if (this.bReattachPending) {
            this.bReattachPending = true;
            this.port.openPort();
            this.port.sendData(enable3ByteStatusCmd, enable3ByteStatusCmd.length);
            if (this.getStatusNotify() == 2) {
                if (this.log.getFWBusy()) {
                    return;
                }
                if (this.bLiveWeight) {
                    this.port.stopLiveWeight();
                    this.bLiveWeight = this.getMetricMode() ? this.port.startLiveWeight(metricWeightCmd, metricWeightCmd.length, this.getPollRate()) : this.port.startLiveWeight(englishWeightCmd, englishWeightCmd.length, this.getPollRate());
                }
            }
        }
    }

    public void onDeviceRemoved() {
        if (!this.bReattachPending) {
            try {
                this.port.closePort();
                this.fireDeviceErrorEvent(-116);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void directIO(int command, int[] data, Object object) throws DLSException {
        this.log.in(this, "directIO: " + command);
        if (this.log.getFWBusy()) {
            return;
        }
        byte[] buf = null;
        this.bDioCommand = true;
        switch (command) {
            case 21: {
                Object object2 = this.objStatus;
                synchronized (object2) {
                    this.reset();
                    try {
                        this.objStatus.wait(2 * this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                    break;
                }
            }
            case 22: {
                Object object2 = this.objStatus;
                synchronized (object2) {
                    this.port.sendData(statusRequestCmd, statusRequestCmd.length);
                    try {
                        this.objStatus.wait(2 * this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                    break;
                }
            }
            case 23: {
                Object object2 = this.objStatus;
                synchronized (object2) {
                    this.port.sendData(statusRequestCmd, statusRequestCmd.length);
                    try {
                        this.objStatus.wait(2 * this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    buf = new byte[]{this.nStat1, this.nStat2};
                    break;
                }
            }
            case 24: {
                Object object2 = this.objStatus;
                synchronized (object2) {
                    if (data.length < 3) throw new DLSException(-2147483637, "Data array, invalid size");
                    this.configureScaleCmd[2] = (byte)data[0];
                    this.configureScaleCmd[3] = (byte)data[1];
                    this.configureScaleCmd[4] = (byte)data[2];
                    this.port.sendData(this.configureScaleCmd, this.configureScaleCmd.length);
                    this.port.sendData(statusRequestCmd, statusRequestCmd.length);
                    try {
                        this.objStatus.wait(2 * this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                    break;
                }
            }
            case 25: {
                this.reportConfiguration();
                if (this.dataBuf != null) {
                    buf = new byte[]{this.dataBuf[3], this.dataBuf[4], this.dataBuf[5]};
                    break;
                }
                this.log.trace(this, "dataBuf returned as null");
                break;
            }
            case 41: {
                buf = new String("USB").getBytes();
                break;
            }
            default: {
                throw new DLSException(-2147483637, "Invalid directio command received");
            }
        }
        if (buf != null) {
            try {
                ByteArrayOutputStream bs = (ByteArrayOutputStream)object;
                if (bs instanceof ByteArrayOutputStream) {
                    bs.write(buf);
                }
            }
            catch (Exception e) {
                this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
                throw new DLSException(-2147483637, "Need a ByteArrayOutStream object to return data");
            }
        }
        this.log.out(this, "directIO");
    }

    public Hashtable getStatistics() throws DLSException {
        this.log.in(this, "getStatistics");
        Hashtable<String, String> table = new Hashtable<String, String>();
        String put = table.put(DLS_S_DEVICE_CATEGORY, "Scale");
        put = table.put(DLS_S_GOOD_WEIGHT_READ_COUNT, "NA");
        put = table.put(DLS_S_INTERFACE, "USB");
        this.log.out(this, "getStatistics");
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int len) {
        int nResp = 0;
        Object object = this.objStatus;
        synchronized (object) {
            nResp |= inBuf[0];
            nResp |= inBuf[1] << 8;
            nResp |= inBuf[2] << 16;
            this.nStat1 = inBuf[0];
            this.nStat2 = inBuf[1];
            this.nStat3 = inBuf[2];
            if (this.bLiveWeight && !this.bGetWeight) {
                int nCurStatus = 0;
                int nCurWeight = 0;
                if ((nResp & 0x80) == 128) {
                    nCurStatus = 15;
                } else if ((nResp & 0x20000) == 131072) {
                    nCurStatus = 16;
                } else if ((nResp & 0x40000) == 262144) {
                    nCurStatus = 14;
                } else if ((nResp & 0x400) == 1024) {
                    nCurStatus = 12;
                } else if ((nResp & 0x80000) == 524288) {
                    nCurStatus = 13;
                } else {
                    nCurStatus = 11;
                    int digits = 4;
                    if ((nResp & 0x200) == 512 || (nResp & 0x100) == 256) {
                        digits = 5;
                    }
                    String strWeight = "";
                    for (int i = 0; i < digits; ++i) {
                        strWeight = strWeight + inBuf[i + 3];
                    }
                    nCurWeight = Integer.parseInt(strWeight);
                    if (digits == 4) {
                        nCurWeight *= 10;
                    }
                }
                if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
                    this.setStatusValue(nCurStatus);
                    if (nCurStatus == 11 || nCurStatus == 13) {
                        this.setLiveWeight(nCurWeight);
                    }
                    if (this.bLiveWeight) {
                        this.onStatusUpdate(nCurStatus);
                    }
                }
                return;
            }
            this.objStatus.notifyAll();
        }
        if ((nResp & 0x80) == 128) {
            object = this.statusResp;
            synchronized (object) {
                this.bDeviceReady = false;
                this.statusResp.notifyAll();
                return;
            }
        }
        object = this.statusResp;
        synchronized (object) {
            this.bDeviceReady = true;
            this.statusResp.notifyAll();
        }
        if ((nResp & 0x10000) == 65536) {
            object = this.updateResp;
            synchronized (object) {
                this.dataBuf = inBuf;
                this.updateResp.notifyAll();
                return;
            }
        }
        if ((nResp & 2) == 2) {
            object = this.reportResp;
            synchronized (object) {
                this.dataBuf = inBuf;
                this.reportResp.notifyAll();
                return;
            }
        }
        if (this.bDioCommand) {
            this.bDioCommand = false;
            return;
        }
        if ((nResp & 0x40) == 64) {
            this.fireDeviceErrorEvent(-100);
        } else if ((nResp & 0x800) == 2048) {
            this.fireDeviceErrorEvent(-102);
        } else if ((nResp & 0x1000) == 4096) {
            this.fireDeviceErrorEvent(-103);
        } else if ((nResp & 0x2000) == 8192) {
            this.fireDeviceErrorEvent(-104);
        } else if ((nResp & 0x4000) == 16384) {
            this.fireDeviceErrorEvent(-105);
        } else if ((nResp & 0x8000) == 32768) {
            this.fireDeviceErrorEvent(-106);
        } else if ((nResp & 0x40000) == 262144) {
            this.fireDeviceErrorEvent(-107);
        } else if ((nResp & 0x20000) == 131072) {
            this.fireDeviceErrorEvent(-107);
        } else if ((nResp & 0x100000) == 0x100000) {
            this.fireDeviceErrorEvent(-108);
        } else if ((nResp & 0x200000) == 0x200000) {
            this.fireDeviceErrorEvent(-109);
        } else if ((nResp & 0x400000) == 0x400000) {
            this.fireDeviceErrorEvent(-110);
        } else if ((nResp & 0x400) == 1024) {
            this.fireDeviceErrorEvent(-101);
        } else if ((nResp & 0x80000) == 524288) {
            if (this.bZeroValid) {
                this.fireWeightEvent(nResp, inBuf);
            } else {
                this.fireDeviceErrorEvent(-117);
            }
        } else {
            this.fireWeightEvent(nResp, inBuf);
        }
        this.bGetWeight = false;
    }
}

