/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class DLSVirtualSerialScanner
extends DLSScanner
implements DLSJposConst {
    protected int CMD_POS = 0;
    protected static final String healthRequestCmd = "h";
    protected static final String statisticsCmd = "s";
    protected int nWaitingOnEot = 0;
    protected byte[] sohBuf;
    protected final Object objWaitSohBuf = new Object();
    protected boolean bFirmware = false;
    protected boolean bIsEnabled = false;
    protected final Object objWaitAck = new Object();
    public int returnType = 0;
    public int returnQty = 0;
    String decodeType = null;
    DataPumpThread dpt = new DataPumpThread();
    public boolean allDone = false;

    public DLSVirtualSerialScanner() {
        this.dpt.pleaseWait = true;
        this.dpt.start();
    }

    protected int sendMsg(String msg) {
        return 0;
    }

    protected int sendMsg(byte[] buf) {
        return 0;
    }

    protected byte[] sendReceiveMsg(String msg) {
        this.sohBuf = null;
        return this.sohBuf;
    }

    public int sendRecord(String sRecord) {
        this.log.in(this, "sendRecord");
        this.bFirmware = true;
        this.nResponse = 255;
        this.log.out(this, "sendRecord: " + this.nResponse);
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        DataPumpThread dataPumpThread = this.dpt;
        synchronized (dataPumpThread) {
            this.dpt.pleaseWait = false;
            this.dpt.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.dpt.bNotAllDone = false;
        DataPumpThread dataPumpThread = this.dpt;
        synchronized (dataPumpThread) {
            this.dpt.pleaseWait = true;
        }
    }

    public void reset() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
    }

    public void enableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
    }

    public void disableBeep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelfTest() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = null;
                int[] tempBuf = new int[]{1, 2, 80, 49, 50, 3, 2, 76, 49, 3, 2, 67, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 3, 4};
                ByteBuffer byteBuffer = ByteBuffer.allocate(tempBuf.length * 4);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                intBuffer.put(tempBuf);
                byte[] soBuf = byteBuffer.array();
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf == null) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    public boolean doHealthCheck() throws DLSException {
        if (this.log.getFWBusy()) {
            return true;
        }
        return true;
    }

    public boolean isAlive() {
        if (this.log.getFWBusy()) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    public void setFirmwareBaudRate() {
        this.log.in(this, "setFirmwareBaudRate");
        this.log.out(this, "setFirmwareBaudRate");
    }

    public void restoreBaudRate() {
        this.log.in(this, "restoreBaudRate");
        this.log.out(this, "restoreBaudRate");
    }

    public void updateConfiguration() {
        this.log.in(this, "updateConfiguration");
        this.log.out(this, "updateConfiguration");
    }

    public DLSScannerConfig reportConfiguration() {
        this.log.in(this, "reportConfiguration");
        this.log.out(this, "reportConfiguration");
        return this.scannerConfig;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        String strResult = "Invalid Command";
        String sendStr = new String();
        switch (command) {
            case 320: {
                String sDispOne = (String)object;
                this.sendMsg("@" + sDispOne + "\r");
                strResult = "Single Line";
                break;
            }
            case 334: {
                Object[] inObject = (Object[])object;
                String[] inStringArray = (String[])inObject;
                this.sendMsg("@" + inStringArray[0] + inStringArray[1] + "\r");
                strResult = "Double Line";
                break;
            }
            case 332: {
                data[0] = this.returnType;
                break;
            }
            case 331: {
                data[0] = this.returnQty;
                break;
            }
            case 333: {
                byte[] outBuf = (byte[])object;
                int sentBytes = this.sendMsg(outBuf);
                strResult = "Display Data";
                break;
            }
            case 335: {
                data[0] = this.returnType;
                strResult = "Return Data";
            }
        }
    }

    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    public Hashtable getStatistics() throws DLSException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        String put = table.put(DLS_S_GOOD_SCAN_COUNT, "NA");
        if (this.log.getFWBusy()) {
            return table;
        }
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object strInfo = null;
            Object str = null;
            Object truncated = null;
            boolean i = false;
            put = table.put(DLS_HH_RADIO_VERSION, "R96-0000");
            put = table.put(DLS_HH_RADIO_APP_VERSION, "R96-0001");
            put = table.put(DLS_S_MODEL_NAME, "1234-567-890");
            put = table.put(DLS_S_SCANNER_BOARD_SERIAL, "SN00011122233");
            put = table.put(DLS_HH_MODEL_NAME, "VirtualSerialScanner");
            put = table.put(DLS_HH_BASE_SERIAL_NUMBER, "SN00011122232");
            put = table.put(DLS_HH_BASE_APP_VERSION, "R96-0002");
            put = table.put(DLS_HH_BATTERY_CHG_CYCLES, "24");
            put = table.put(DLS_HH_TRIGGER_PULLS, "100");
            put = table.put(DLS_HH_KEY_PRESSES, "32");
            put = table.put(DLS_HH_LASER_ON_TIME, "45");
            put = table.put(DLS_S_GOOD_SCAN_COUNT, "123");
            put = table.put(DLS_HH_BASE_HOURS_POWERED_COUNT, "123");
            put = table.put(DLS_S_MODEL_NAME, "VirtualSerialScanner");
            put = table.put(DLS_S_SERIAL_NUMBER, "SN00011122231");
            put = table.put(DLS_S_SCANNER_BOARD_SERIAL, "SN00011122230");
            put = table.put(DLS_S_FIRMWARE_VERSION, "R96-0003");
            put = table.put(DLS_S_SCANNER_REVISION, "1.23");
            put = table.put(DLS_S_SCANNER_CONFIG_FILE_ID, "R96-0004");
            put = table.put(DLS_S_SCANNER_BOOT_ROM_ID, "R96-0005");
            put = table.put(DLS_S_UNIVERSAL_ROM_ID, "R96-0006");
            put = table.put(DLS_S_UNIVERSAL_BOOT_ROM_ID, "R96-0006");
            put = table.put(DLS_S_SCALE_INFO, "ScaleInfo");
            put = table.put(DLS_S_DISPLAY_VERSION, "R96-0007");
            put = table.put(DLS_S_EAS_VERSION, "2.34");
            put = table.put(DLS_S_SCANNER_INTERFACE, "VIRTUAL");
            put = table.put(DLS_S_SCANNER_TIME, "101");
            put = table.put(DLS_S_HOURS_POWERED_COUNT, "122");
            put = table.put(DLS_S_LASER_TIME, "66");
            put = table.put(DLS_S_GOOD_SCAN_COUNT, "1234");
            put = table.put(DLS_S_SCALE_ZEROS, "9");
            put = table.put(DLS_S_SCALE_CALS, "5");
            put = table.put(DLS_S_SCALE_CAL_TIME, "223");
            put = table.put(DLS_S_EAS_DEACTIVATED, "44");
            put = table.put(DLS_S_EAS_MANUAL, "22");
            put = table.put(DLS_S_MOTOR_HEALTH, "OK");
            put = table.put(DLS_S_V_LASER_HEALTH, "OK");
            put = table.put(DLS_S_H_LASER_HEALTH, "OK");
            put = table.put(DLS_S_SCALE_HEALTH, "NA");
            put = table.put(DLS_S_REMOTE_DISPLAY_HEALTH, "NA");
            put = table.put(DLS_S_EAS_HEALTH, "OK");
            put = table.put(DLS_S_CAMERA_HEALTH, "OK");
            put = table.put(DLS_HH_RADIO_HEALTH, "OK");
            put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
            put = table.put(DLS_S_INTERFACE, "VIRTUAL");
            String msg = this.scannerInfo(table);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        if (this.bFirmware) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                this.log.out(this, "onDataReceived:" + this.nResponse);
                this.objWaitAck.notify();
                return;
            }
        }
        if (this.bs.size() == 0 && inBuf[0] == 1 || this.nWaitingOnEot > 0) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                ++this.nWaitingOnEot;
                this.parseMessages(inBuf, (byte)4);
                if (this.msgList.size() > 0) {
                    this.nWaitingOnEot = 0;
                    this.sohBuf = (byte[])this.msgList.get(0);
                    this.msgList.clear();
                    this.objWaitSohBuf.notifyAll();
                } else if (this.nWaitingOnEot > 30) {
                    this.nWaitingOnEot = 0;
                    this.bs.reset();
                    this.msgList.clear();
                }
            }
            return;
        }
        this.parseMessages(inBuf, this.deviceInfo.getRxTrailer());
        if (!this.bIsEnabled) {
            this.sohBuf = (byte[])this.msgList.get(0);
            return;
        }
        this.decodeType = this.deviceInfo.getDecodingType();
        Iterator it = this.msgList.iterator();
        while (it.hasNext()) {
            byte[] tmpBuf = (byte[])it.next();
            byte pre = this.deviceInfo.getRxPrefix();
            if (tmpBuf.length <= 2) continue;
            if (pre == tmpBuf[0]) {
                this.CMD_POS = 1;
            }
            int nType = this.extractBarcodeType(tmpBuf[this.CMD_POS], tmpBuf[this.CMD_POS + 1]);
            byte[] barcode = this.extractBarcodeLabel(tmpBuf, 0);
            switch (nType) {
                case 101: {
                    if (barcode.length <= 12) break;
                    nType = 111;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCA_S");
                    break;
                }
                case 102: {
                    if (barcode.length <= 8) break;
                    nType = 112;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCE_S");
                    break;
                }
                case 103: {
                    if (barcode.length <= 8) break;
                    nType = 118;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN8_S");
                    break;
                }
                case 104: {
                    if (barcode.length <= 13) break;
                    nType = 119;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN13_S");
                }
            }
            DLSProperties options = DLSProperties.getInstance();
            boolean bSendCookedData = options.get("com.dls.jpos.service.ScannerService.sendCookedData", true);
            if (bSendCookedData) {
                tmpBuf = barcode;
            }
            this.fireLabelReceivedEvent(tmpBuf, barcode, nType);
        }
        this.msgList.clear();
    }

    private int extractLocalBarcodeType(byte b1, byte b2) {
        int nType = 0;
        switch (b1) {
            case 73: {
                nType = 106;
                this.log.log(this, "bar code type = SCAN_SDT_ITF");
                break;
            }
            case 72: {
                nType = 105;
                this.log.log(this, "bar code type = SCAN_SDT_TF");
                break;
            }
            case 66: {
                nType = 103;
                this.log.log(this, "bar code type = SCAN_SDT_EAN8");
                break;
            }
            case 65: {
                nType = 104;
                this.log.log(this, "bar code type = SCAN_SDT_EAN13");
                break;
            }
            case 67: {
                nType = 102;
                this.log.log(this, "bar code type = SCAN_SDT_UPCE");
                break;
            }
            case 77: {
                nType = 108;
                this.log.log(this, "bar code type = SCAN_SDT_Code39");
                break;
            }
            case 78: {
                nType = 107;
                this.log.log(this, "bar code type = SCAN_SDT_Codabar");
                break;
            }
            case 80: {
                nType = 120;
                this.log.log(this, "bar code type = SCAN_SDT_EAN128");
                break;
            }
            case 75: {
                nType = 110;
                this.log.log(this, "bar code type = SCAN_SDT_Code128");
                break;
            }
            case 76: {
                nType = 109;
                this.log.log(this, "bar code type = SCAN_SDT_Code93");
                break;
            }
            case 69: {
                nType = 131;
                this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR");
                break;
            }
            case 79: {
                nType = 501;
                this.log.log(this, "bar code type = SCAN_SDT_OTHER");
            }
        }
        return nType;
    }

    private byte[] extractLocalBarcodeLabel(byte[] inBuf, int offset) {
        int start = 1;
        switch (inBuf[offset]) {
            case 66: {
                start = 2;
                break;
            }
            case 82: {
                start = 2;
                break;
            }
            case 70: {
                start = inBuf[offset + 1] == 70 ? 2 : 1;
            }
        }
        byte[] buf = new byte[inBuf.length - 1 - (start + offset)];
        int j = 0;
        for (int i = start + offset; i < inBuf.length - 1; ++i) {
            buf[j++] = inBuf[i];
        }
        return buf;
    }

    public String scannerInfo(Hashtable scanHT) {
        String msg = new String();
        String[] stats = new String[reqStatsHH.length];
        System.arraycopy(reqStatsHH, 0, stats, 0, reqStatsHH.length);
        String pad = new String(" = ");
        int sortIndex = 0;
        boolean testIt = false;
        for (sortIndex = 0; sortIndex < sStatsList.length; ++sortIndex) {
            testIt = scanHT.containsKey(sStatsList[sortIndex]);
            if (!testIt) continue;
            msg = msg + sStatsList[sortIndex] + pad + (String)scanHT.get(sStatsList[sortIndex]) + "\r\n";
        }
        DateFormat fDateFormat = DateFormat.getDateTimeInstance(2, 2);
        Date now = new Date();
        String date_out = fDateFormat.format(now);
        msg = msg + "\r\nCreation date: \t" + date_out + "\r\n";
        try {
            DLSProperties options = DLSProperties.getInstance();
            String scannerInfoFilename = options.get("com.dls.jpos.common.ScannerService.ScannerInfoFilename", "scannerinfo.txt");
            File scannerInfoFile = new File(scannerInfoFilename);
            scannerInfoFile.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(scannerInfoFile));
            out.write(msg);
            out.close();
        }
        catch (IOException e) {
            System.err.println("Jpos exception on createNewFile: " + e.toString() + "scannerinfo.txt\n");
            msg = msg + "Exception on createNewFile: " + e + "scannerinfo.txt";
        }
        return msg;
    }

    public void setAllDone() {
        this.allDone = true;
    }

    public void run() {
        int n = 11;
        do {
            try {
                Thread.sleep(454L);
            }
            catch (InterruptedException ex) {
                this.log.in(this, "DataPumpThread exception: " + ex.getLocalizedMessage());
            }
        } while (!this.allDone);
    }

    public int sendJoin() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sendReset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class DataPumpThread
    extends Thread {
        boolean pleaseWait = false;
        boolean bNotAllDone = true;

        private DataPumpThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DLSVirtualSerialScanner.this.log.log(this, "Starting data pump thread.");
            byte[] buf = new byte[]{67, 48, 52, 56, 53, 48, 48, 48, 48, 49, 55, 52, 53, 13};
            int len = buf.length;
            while (true) {
                DataPumpThread dataPumpThread = this;
                synchronized (dataPumpThread) {
                    while (this.pleaseWait) {
                        try {
                            System.out.println("Simulated data send - waiting");
                            this.wait();
                        }
                        catch (Exception e) {}
                    }
                }
                try {
                    Thread.sleep(1000L);
                    System.out.println("Simulated data send");
                    DLSVirtualSerialScanner.this.fireLabelReceivedEvent(buf, buf, 102);
                    DLSVirtualSerialScanner.this.onDataReceived(buf, len);
                    continue;
                }
                catch (InterruptedException e) {
                    DLSVirtualSerialScanner.this.log.error(this, "data pump thread sleep interrupted");
                    continue;
                }
                break;
            }
        }
    }
}

