/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.interpretation.DLSScale;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Iterator;

public class DLSVirtualSerialScale
extends DLSScale
implements DLSJposConst {
    protected static int CMD_POS = 1;
    protected static final String getWeightCmd = "W";
    protected static final String zeroScaleCmd = "Z";
    protected static final String initiateConfidenceTestCmd = "A";
    protected static final String getConfidenceTestResultsCmd = "B";
    protected static final String enterEchoModeCmd = "E";
    protected static final String exitEchoModeCmd = "F";
    protected boolean bConfidenceTest = false;
    protected Object confidenceTest = new Object();
    protected byte confidenceByte = 0;
    protected Object dataReceived = new Object();
    protected byte[] dataBuf = null;
    protected int timeOut = 2000;
    protected boolean bGetWeight = false;
    private boolean bZeroValid = false;

    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendMsg(String msg, boolean bWait) {
        Object object = this.dataReceived;
        synchronized (object) {
            this.dataBuf = null;
            this.sendMsg(msg);
            try {
                this.dataReceived.wait(this.nTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return this.dataBuf;
    }

    public void setMetricMode(boolean bValue) {
        this.log.in(this, "setMetricMode");
        super.setMetricMode(bValue);
        this.log.out(this, "setMetricMode");
    }

    public DLSCConfig getConfiguration() {
        return super.getConfiguration();
    }

    public void enable() throws DLSException {
        this.log.in(this, "enable");
        if (this.log.getFWBusy()) {
            this.log.error(this, "Firmware update in progress.");
            return;
        }
        if (!this.isAlive()) {
            this.log.error(this, "No RS232 Standard Scale device attached to port.");
            throw new DLSException(-2147483641, "No RS232 Standard Scale device attached to port.");
        }
        if (this.getStatusNotify() == 2) {
            this.startLiveWeight();
        }
        this.log.out(this, "enable");
    }

    public void disable() throws DLSException {
        this.log.in(this, "disable");
        this.stopLiveWeight();
        this.log.out(this, "disable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelfTest() {
        this.log.in(this, "peformSelfTest");
        if (this.log.getFWBusy()) {
            this.log.error(this, "Firmware update in progress.");
            return;
        }
        this.sendMsg(initiateConfidenceTestCmd, true);
        Object object = this.confidenceTest;
        synchronized (object) {
            this.bAlive = false;
            this.bConfidenceTest = true;
            this.confidenceByte = 0;
            this.sendMsg(getConfidenceTestResultsCmd);
            try {
                this.confidenceTest.wait(this.nTimeout);
                if ((this.confidenceByte & 0x1F) == 31) {
                    this.bAlive = true;
                } else if (this.confidenceByte == 0) {
                    this.fireDeviceErrorEvent(-116);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.log.out(this, "doSelfTest");
    }

    public boolean doHealthCheck() throws DLSException {
        this.log.in(this, "doHealthCheck");
        boolean bRc = this.isAlive();
        if ((this.confidenceByte & 1) != 1) {
            throw new DLSException(-2147483639, "EEPROM 1 Test failed");
        }
        if ((this.confidenceByte & 2) != 2) {
            throw new DLSException(-2147483639, "EEPROM 2 Test failed");
        }
        if ((this.confidenceByte & 4) != 4) {
            throw new DLSException(-2147483639, "RAM Test failed");
        }
        if ((this.confidenceByte & 8) != 8) {
            throw new DLSException(-2147483639, "Processor RAM Test failed");
        }
        if ((this.confidenceByte & 0x10) != 16) {
            throw new DLSException(-2147483639, "ROM Test failed");
        }
        this.log.out(this, "doHealthCheck");
        return bRc;
    }

    public boolean isAlive() {
        this.log.in(this, "isAlive");
        boolean bRc = true;
        this.doSelfTest();
        this.log.out(this, "bAlive=" + this.bAlive);
        return this.bAlive;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
        this.log.in(this, "directIO");
        if (this.log.getFWBusy()) {
            return;
        }
        String strResult = "Invalid Command";
        switch (command) {
            case 27: {
                this.sendMsg(getWeightCmd, true);
                strResult = "Status ";
                if (this.dataBuf != null) {
                    if (this.dataBuf[CMD_POS] == 63) {
                        byte status = this.dataBuf[CMD_POS + 1];
                        if ((status & 4) == 4) {
                            strResult = strResult + ", under zero";
                        }
                        if ((status & 2) == 2) {
                            strResult = strResult + ", overweight";
                        }
                        if ((status & 1) == 1) {
                            strResult = strResult + ", in motion";
                        }
                        if ((status & 8) != 8) break;
                        strResult = strResult + ", out of zero capture range";
                        break;
                    }
                    strResult = "Weight - ";
                    for (int i = 1; i < this.dataBuf.length - 1; ++i) {
                        if (this.dataBuf[i] < 48 || this.dataBuf[i] > 57) continue;
                        strResult = strResult + (this.dataBuf[i] - 48);
                    }
                    break;
                }
                strResult = strResult + ", no response";
                break;
            }
            case 30: {
                if (this.isAlive()) {
                    strResult = "Selftest - ";
                    strResult = strResult + ((this.confidenceByte & 8) == 8 ? "processor passed, " : "processor FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 0x10) == 16 ? "ROM passed, " : "ROM FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 4) == 4 ? "RAM passed, " : "RAM FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 1) == 1 ? "EEPROM1 passed, " : "EEPROM1 FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 2) == 2 ? "EEPROM2 passed" : "EEPROM2 FAILED");
                    break;
                }
                strResult = "Device not responding";
                break;
            }
            case 41: {
                strResult = "RS232 - SASI";
            }
        }
        try {
            ByteArrayOutputStream bs = (ByteArrayOutputStream)object;
            if (bs instanceof ByteArrayOutputStream) {
                bs.write(strResult.getBytes());
            }
        }
        catch (Exception e) {
            this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
        }
        this.log.out(this, "directIO");
    }

    public void reset() throws DLSException {
        this.log.in(this, "reset");
        this.log.out(this, "reset");
    }

    public void clearDisplay() {
        this.log.in(this, "clearDisplay");
        this.log.out(this, "clearDisplay");
    }

    public void zeroScale() {
        this.log.in(this, "zeroScale");
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(zeroScaleCmd);
        this.log.out(this, "zeroScale");
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public boolean canZeroScale() {
        return true;
    }

    public void updateConfiguration() {
        this.log.in(this, "updateConfiguration");
        this.log.out(this, "updateConfiguration");
    }

    public void reportConfiguration() {
        this.log.in(this, "reportConfiguration");
        this.log.out(this, "reportConfiguration");
    }

    public void readEnglishWeight() {
        this.log.in(this, "readEnglishWeight");
        if (this.log.getFWBusy()) {
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(getWeightCmd);
        this.log.out(this, "readEnglishWeight");
    }

    public void readMetricWeight() {
        this.log.in(this, "readMetricWeight");
        if (this.log.getFWBusy()) {
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(getWeightCmd);
        this.log.out(this, "readMetricWeight");
    }

    public Hashtable getStatistics() throws DLSException {
        this.log.in(this, "getStatistics");
        Hashtable<String, String> table = new Hashtable<String, String>();
        Object put = new Object();
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scale");
        put = table.put(DLS_S_GOOD_WEIGHT_READ_COUNT, "NA");
        put = table.put(DLS_S_INTERFACE, "RS232");
        this.log.out(this, "getStatistics");
        return table;
    }

    public void readStatusWeight() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(getWeightCmd, true);
        if (this.dataBuf == null) {
            throw new DLSException(-2147483640, "readStatusWeight timeout");
        }
        int nCurStatus = 0;
        int nCurWeight = 0;
        if (this.dataBuf[CMD_POS] == 63) {
            byte status = this.dataBuf[CMD_POS + 1];
            if ((status & 4) == 4) {
                nCurStatus = 16;
            } else if ((status & 2) == 2) {
                nCurStatus = 14;
            } else if ((status & 1) == 1) {
                nCurStatus = 12;
            } else if ((status & 8) == 8) {
                nCurStatus = 13;
            }
        } else {
            nCurStatus = 11;
            String strWeight = "";
            int ndxPeriod = 0;
            if (this.dataBuf.length < 3) {
                throw new DLSException(-2147483639, "Live Weight invalid.");
            }
            for (int i = CMD_POS; i < this.dataBuf.length; ++i) {
                if (this.dataBuf[i] == 46) {
                    ndxPeriod = i;
                }
                if (this.dataBuf[i] < 48 || this.dataBuf[i] > 57) continue;
                strWeight = strWeight + (this.dataBuf[i] - 48);
            }
            nCurWeight = Integer.parseInt(strWeight);
            if (ndxPeriod == 4) {
                nCurWeight *= 10;
            }
        }
        if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
            this.setStatusValue(nCurStatus);
            if (nCurStatus == 11) {
                this.setLiveWeight(nCurWeight);
            }
            this.onStatusUpdate(nCurStatus);
        }
    }

    public void onStatusUpdate(int nStatus) {
        this.fireDeviceStatusEvent(nStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int len) {
        this.parseMessages(inBuf, this.deviceInfo.getRxTrailer());
        Iterator it = this.msgList.iterator();
        while (it.hasNext()) {
            byte[] tmpBuf = (byte[])it.next();
            Object object = this.dataReceived;
            synchronized (object) {
                this.dataBuf = tmpBuf;
                this.dataReceived.notifyAll();
            }
            if (this.isLiveWeight() && !this.bGetWeight && !this.bConfidenceTest) break;
            this.bGetWeight = false;
            this.bZeroValid = super.getZeroValid();
            if (tmpBuf.length <= CMD_POS) continue;
            byte pre = this.deviceInfo.getRxPrefix();
            CMD_POS = pre == tmpBuf[0] ? 1 : 0;
            switch (tmpBuf[CMD_POS]) {
                case 63: {
                    byte status = tmpBuf[CMD_POS + 1];
                    Object object2 = this.confidenceTest;
                    synchronized (object2) {
                        if (this.bConfidenceTest) {
                            this.bConfidenceTest = false;
                            this.confidenceByte = status;
                            this.confidenceTest.notifyAll();
                        } else if ((status & 1) == 1) {
                            this.fireDeviceErrorEvent(-101);
                        } else if ((status & 2) == 2) {
                            this.fireDeviceErrorEvent(-107);
                        } else if ((status & 4) == 4) {
                            this.fireDeviceErrorEvent(-108);
                        } else if ((status & 0x10) == 16) {
                            if (this.bZeroValid) {
                                if (tmpBuf.length < 3) {
                                    break;
                                }
                                String strWeight = "";
                                int ndxPeriod = 0;
                                for (int i = CMD_POS; i < tmpBuf.length; ++i) {
                                    if (tmpBuf[i] == 46) {
                                        ndxPeriod = i;
                                    }
                                    if (tmpBuf[i] < 48 || tmpBuf[i] > 57) continue;
                                    strWeight = strWeight + (tmpBuf[i] - 48);
                                }
                                int nWeight = Integer.parseInt(strWeight);
                                if (nWeight == 0 && !this.bZeroValid) {
                                    this.fireDeviceErrorEvent(-117);
                                } else {
                                    if (ndxPeriod == 4) {
                                        nWeight *= 10;
                                    }
                                    try {
                                        this.fireWeightReceivedEvent(nWeight);
                                    }
                                    catch (NumberFormatException e) {
                                        this.log.error(this, "Number format exception in weight read: " + e.getMessage());
                                    }
                                }
                            } else {
                                this.fireDeviceErrorEvent(-117);
                            }
                        }
                        break;
                    }
                }
                default: {
                    if (tmpBuf.length < 3) break;
                    String strWeight = "";
                    int ndxPeriod = 0;
                    for (int i = CMD_POS; i < tmpBuf.length; ++i) {
                        if (tmpBuf[i] == 46) {
                            ndxPeriod = i;
                        }
                        if (tmpBuf[i] < 48 || tmpBuf[i] > 57) continue;
                        strWeight = strWeight + (tmpBuf[i] - 48);
                    }
                    int nWeight = Integer.parseInt(strWeight);
                    if (nWeight == 0 && !this.bZeroValid) {
                        this.fireDeviceErrorEvent(-117);
                        break;
                    }
                    if (ndxPeriod == 4) {
                        nWeight *= 10;
                    }
                    try {
                        this.fireWeightReceivedEvent(nWeight);
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this, "Number format exception in weight read: " + e.getMessage());
                    }
                }
            }
        }
        this.msgList.clear();
    }
}

