/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.interpretation.DLSScale;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Iterator;

public class DLSVirtualSCSerialScale
extends DLSScale
implements DLSJposConst {
    protected static int DST_POS = 1;
    protected static int CMD_POS = 2;
    protected static final String getWeightCmd = "11";
    protected static final String cancelCmd = "12";
    protected static final String statusCmd = "13";
    protected static final String monitorCmd = "14";
    protected static final String hardResetCmd = "00";
    protected static final String shutDownCmd = "335";
    protected static final String displayStatusCmd = "23";
    protected Object objResponse = new Object();
    protected byte[] respBuf = null;
    protected Object statusResponse = new Object();
    protected byte[] statusBuf = null;
    protected Object monitorResponse = new Object();
    protected byte[] monitorBuf = null;
    protected boolean bGetWeight = false;
    protected boolean bZeroValid = false;

    public void open(String strLogicalName) throws DLSException {
        super.open(strLogicalName);
        byte b = this.deviceInfo.getRxPrefix();
        if (b == 0) {
            CMD_POS = 1;
            DST_POS = 0;
        } else {
            CMD_POS = 2;
            DST_POS = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveStatusMsg(String strMsg) {
        this.log.in(this, "sendReceiveMsg");
        this.statusBuf = null;
        Object object = this.statusResponse;
        synchronized (object) {
            this.sendMsg(strMsg);
            try {
                this.statusResponse.wait(this.nTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.log.out(this, "sendReceiveMsg");
        return this.statusBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMonitorMsg(String strMsg) {
        this.log.in(this, "sendReceiveMsg");
        this.monitorBuf = null;
        Object object = this.monitorResponse;
        synchronized (object) {
            this.sendMsg(strMsg);
            try {
                this.monitorResponse.wait(this.nTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.log.out(this, "sendReceiveMsg");
        return this.monitorBuf;
    }

    public void setMetricMode(boolean bValue) {
        this.log.in(this, "setMetricMode");
        super.setMetricMode(bValue);
        this.log.out(this, "setMetricMode");
    }

    public DLSCConfig getConfiguration() {
        return super.getConfiguration();
    }

    public void enable() throws DLSException {
        this.log.in(this, "enable");
        if (this.log.getFWBusy()) {
            this.log.error(this, "Firmware update in progress.");
            return;
        }
        if (!this.isAlive()) {
            this.log.error(this, "No RS232 SingleCable Scale device attached to port.");
            throw new DLSException(-2147483641, "No RS232 SingleCable Scale device attached to port.");
        }
        if (this.getStatusNotify() == 2) {
            this.startLiveWeight();
        }
        this.log.out(this, "enable");
    }

    public void disable() throws DLSException {
        this.log.in(this, "disable");
        this.stopLiveWeight();
        this.log.out(this, "disable");
    }

    public void doSelfTest() {
        this.log.in(this, "doSelfTest");
        if (this.log.getFWBusy()) {
            this.log.error(this, "Firmware update in progress.");
            return;
        }
        this.bAlive = true;
        byte[] resp = this.sendReceiveStatusMsg(statusCmd);
        if (resp == null) {
            this.bAlive = false;
            this.log.trace(this, "firing device error event");
            this.fireDeviceErrorEvent(-116);
        }
        this.log.out(this, "doSelfTest");
    }

    public boolean doHealthCheck() throws DLSException {
        this.log.in(this, "doHealthCheck");
        boolean bRc = true;
        bRc = this.isAlive();
        this.log.out(this, "doHealthCheck: " + bRc);
        return bRc;
    }

    public boolean isAlive() {
        this.log.in(this, "isAlive");
        boolean bRc = true;
        this.doSelfTest();
        this.log.out(this, "isAlive: " + this.bAlive);
        return this.bAlive;
    }

    public void directIO(int command, int[] data, Object object) {
        this.log.in(this, "directIO");
        if (this.log.getFWBusy()) {
            return;
        }
        String strResult = "Invalid command";
        byte[] buf = null;
        block1 : switch (command) {
            case 21: {
                this.sendMsg(hardResetCmd);
                strResult = "Scale reset";
                break;
            }
            case 27: 
            case 601: {
                buf = this.sendReceiveStatusMsg(statusCmd);
                if (buf.length < 8) {
                    strResult = "Invalid response from scale.";
                    break;
                }
                strResult = buf[3] == 48 ? "English," : "Metric,";
                strResult = buf[4] == 48 ? strResult + "Enabled," : strResult + "Disabled,";
                switch (buf[7]) {
                    case 48: {
                        strResult = strResult + "Scale is not ready";
                        break;
                    }
                    case 49: {
                        strResult = strResult + "Non-stable weight";
                        break;
                    }
                    case 50: {
                        strResult = strResult + "Stable Overweight";
                        break;
                    }
                    case 51: {
                        strResult = strResult + "Stable zero weight";
                        break;
                    }
                    case 52: {
                        strResult = strResult + "Stable non-zero weight";
                        break;
                    }
                    case 53: {
                        strResult = strResult + "Current stable non-zero weight";
                        break;
                    }
                    case 112: {
                        strResult = strResult + "Calibration Phase 1 (Empty scale and press scale calibration button)";
                        break;
                    }
                    case 113: {
                        strResult = strResult + "Calibration Phase 2 (Calibrating zero weight)";
                        break;
                    }
                    case 114: {
                        strResult = strResult + "Calibration Phase 3 (Add high calibration weight and press scale button)";
                        break;
                    }
                    case 115: {
                        strResult = strResult + "Calibration Phase 4 (Calibrating high weight)";
                        break;
                    }
                    case 116: {
                        strResult = strResult + "Calibration Phase 5 (Calibration done. Press scale button)";
                        break;
                    }
                    case 117: {
                        strResult = strResult + "Recalibration required";
                    }
                }
                break;
            }
            case 26: 
            case 604: {
                buf = this.sendReceiveMonitorMsg(monitorCmd);
                if (buf == null || buf[1] != 49 || buf[2] != 52) break;
                switch (buf[3]) {
                    case 48: {
                        strResult = "Scale not ready";
                        break;
                    }
                    case 49: {
                        strResult = "Scale unstable";
                        break;
                    }
                    case 50: {
                        strResult = "Scale over capacity";
                        break;
                    }
                    case 51: {
                        strResult = "000";
                        break;
                    }
                    case 52: {
                        strResult = "";
                        for (int i = 4; i < buf.length - 1; ++i) {
                            strResult = strResult + (buf[i] - 48);
                        }
                        break block1;
                    }
                    case 53: {
                        strResult = "Scale under zero";
                        break;
                    }
                    case 112: {
                        strResult = "Calibration Phase 1 (Empty scale and press scale calibration button)";
                        break;
                    }
                    case 113: {
                        strResult = "Calibration Phase 2 (Calibrating zero weight)";
                        break;
                    }
                    case 114: {
                        strResult = "Calibration Phase 3 (Add high calibration weight and press scale button)";
                        break;
                    }
                    case 115: {
                        strResult = "Calibration Phase 4 (Calibrating high weight)";
                        break;
                    }
                    case 116: {
                        strResult = "Calibration Phase 5 (Calibration done. Press scale button)";
                        break;
                    }
                    case 117: {
                        strResult = "Recalibration required";
                    }
                }
                break;
            }
            case 28: {
                buf = this.sendReceiveStatusMsg(displayStatusCmd);
                if (buf.length < 4) {
                    strResult = "Response error";
                    break;
                }
                if (buf[3] == 48) {
                    strResult = "Price/Weight,";
                    break;
                }
                if (buf[3] == 49) {
                    strResult = "Weight";
                    break;
                }
                strResult = "Alphanumeric";
                break;
            }
            case 29: {
                this.sendMsg(shutDownCmd);
                strResult = "Soft power down";
                break;
            }
            case 41: {
                strResult = "RS232-SC";
            }
        }
        try {
            ByteArrayOutputStream bs = (ByteArrayOutputStream)object;
            if (bs instanceof ByteArrayOutputStream) {
                bs.write(strResult.getBytes());
            }
        }
        catch (Exception e) {
            this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
        }
        this.log.out(this, "directIO");
    }

    public void reset() throws DLSException {
        this.log.in(this, "reset");
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(hardResetCmd);
        this.log.out(this, "reset");
    }

    public void clearDisplay() {
        this.log.in(this, "clearDisplay");
        this.log.out(this, "clearDisplay");
    }

    public void zeroScale() {
        this.log.in(this, "zeroScale");
        this.log.out(this, "zeroScale");
    }

    public boolean canZeroScale() {
        return false;
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void updateConfiguration() {
        this.log.in(this, "updateConfiguration");
        this.log.out(this, "updateConfiguration");
    }

    public void reportConfiguration() {
        this.log.in(this, "reportConfiguration");
        this.log.out(this, "reportConfiguration");
    }

    public void readMetricWeight() {
        this.log.in(this, "readMetricWeight");
        if (this.log.getFWBusy()) {
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(monitorCmd);
        this.log.out(this, "readMetricWeight");
    }

    public void readEnglishWeight() {
        this.log.in(this, "readEnglishWeight");
        if (this.log.getFWBusy()) {
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(monitorCmd);
        this.log.out(this, "readEnglishWeight");
    }

    public Hashtable getStatistics() throws DLSException {
        this.log.in(this, "getStatistics");
        Hashtable<String, String> table = new Hashtable<String, String>();
        String put = table.put(DLS_S_DEVICE_CATEGORY, "Scale");
        put = table.put(DLS_S_GOOD_WEIGHT_READ_COUNT, "NA");
        put = table.put(DLS_S_INTERFACE, "RS232-SC");
        this.log.out(this, "getStatistics");
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readStatusWeight() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        Object object = this.monitorResponse;
        synchronized (object) {
            this.monitorBuf = null;
            this.sendMsg(monitorCmd);
            try {
                this.monitorResponse.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                throw new DLSException(-2147483640, "readStatusWeight: interrupted.");
            }
        }
        if (this.monitorBuf == null) {
            throw new DLSException(-2147483640, "readStatusWeight timeout");
        }
        int nCurStatus = 0;
        int nCurWeight = 0;
        switch (this.monitorBuf[3]) {
            case 48: {
                nCurStatus = 15;
                break;
            }
            case 49: {
                nCurStatus = 12;
                break;
            }
            case 50: {
                nCurStatus = 14;
                break;
            }
            case 51: {
                nCurStatus = 13;
                break;
            }
            case 53: {
                nCurStatus = 16;
                break;
            }
            case 52: {
                nCurStatus = 11;
                String strResult = "";
                for (int i = 4; i < this.monitorBuf.length - 1; ++i) {
                    strResult = strResult + (this.monitorBuf[i] - 48);
                }
                nCurWeight = Integer.parseInt(strResult);
                if (this.getMetricMode()) break;
                nCurWeight *= 10;
            }
        }
        if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
            this.setStatusValue(nCurStatus);
            if (nCurStatus == 11) {
                this.setLiveWeight(nCurWeight);
            }
            this.onStatusUpdate(nCurStatus);
        }
    }

    public void onStatusUpdate(int nStatus) {
        this.fireDeviceStatusEvent(nStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int len) {
        this.log.in(this, "onDataReceived");
        this.parseMessages(inBuf, this.deviceInfo.getRxTrailer(), this.deviceInfo.getUseBCC());
        Iterator it = this.msgList.iterator();
        while (it.hasNext()) {
            byte[] tmpBuf = (byte[])it.next();
            if (tmpBuf.length <= CMD_POS || tmpBuf[DST_POS] != 49 && tmpBuf[DST_POS] != 50) continue;
            switch (tmpBuf[CMD_POS]) {
                case 49: {
                    String strWeight = "";
                    for (int i = CMD_POS + 1; i < tmpBuf.length - 1; ++i) {
                        strWeight = strWeight + (tmpBuf[i] - 48);
                    }
                    int nWeight = Integer.parseInt(strWeight);
                    if (!this.getMetricMode()) {
                        nWeight *= 10;
                    }
                    this.fireWeightReceivedEvent(nWeight);
                    break;
                }
                case 50: 
                case 51: {
                    Object object = this.statusResponse;
                    synchronized (object) {
                        this.statusBuf = tmpBuf;
                        this.statusResponse.notifyAll();
                        break;
                    }
                }
                case 52: {
                    int nWeight;
                    Object object = this.monitorResponse;
                    synchronized (object) {
                        this.monitorBuf = tmpBuf;
                        this.monitorResponse.notifyAll();
                    }
                    if (this.bGetWeight) {
                        switch (tmpBuf[3]) {
                            case 48: {
                                this.fireDeviceErrorEvent(-112);
                                break;
                            }
                            case 49: {
                                this.fireDeviceErrorEvent(-101);
                                break;
                            }
                            case 50: {
                                this.fireDeviceErrorEvent(-107);
                                break;
                            }
                            case 51: {
                                int i;
                                if (!this.bZeroValid) {
                                    this.fireDeviceErrorEvent(-117);
                                    break;
                                }
                                String strResult = "";
                                for (i = 4; i < tmpBuf.length - 1; ++i) {
                                    strResult = strResult + (tmpBuf[i] - 48);
                                }
                                nWeight = Integer.parseInt(strResult);
                                if (!this.getMetricMode()) {
                                    nWeight *= 10;
                                }
                                this.fireWeightReceivedEvent(nWeight);
                                break;
                            }
                            case 52: {
                                int i;
                                String strResult = "";
                                for (i = 4; i < tmpBuf.length - 1; ++i) {
                                    strResult = strResult + (tmpBuf[i] - 48);
                                }
                                nWeight = Integer.parseInt(strResult);
                                if (!this.getMetricMode()) {
                                    nWeight *= 10;
                                }
                                this.fireWeightReceivedEvent(nWeight);
                                break;
                            }
                            case 53: {
                                this.fireDeviceErrorEvent(-108);
                                break;
                            }
                            case 117: {
                                this.fireDeviceErrorEvent(-108);
                            }
                        }
                    }
                    this.bGetWeight = false;
                    break;
                }
                default: {
                    Object object = this.objResponse;
                    synchronized (object) {
                        this.respBuf = tmpBuf;
                        this.objResponse.notifyAll();
                        break;
                    }
                }
            }
        }
        this.msgList.clear();
        this.log.out(this, "onDataReceived");
    }
}

