/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.interpretation.DLSDevice;

public class DLSUSBFlash
extends DLSDevice
implements DLSJposConst {
    protected boolean bRaiseBusy = true;
    protected static final int RESP_COMMAND_COMPLETE = 1;
    protected static final int RESP_FLASH_LOADING = 2;
    protected static final int RESP_OPERATION_ERROR = 64;
    protected static final int RESP_COMMAND_REJECT = 128;
    public static final int ACK = 6;
    public static final int NAK = 21;
    public static final int CAN = 24;
    public static final int BEL = 7;
    public static final int UNKWN = 239;
    public static final int NRESP = 255;
    public static final int REPORT_COUNT = 263;
    public int nRecordTimeout = 180000;
    protected int nResponse = 0;
    protected boolean bReattachPending = true;
    protected byte nStatus;
    protected Object objStatus = new Object();
    private boolean bWindows = false;
    private byte[] outBuf;

    public DLSUSBFlash() {
        if (this.log.strOS.indexOf(new String("WINDOWS")) >= 0) {
            this.bWindows = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startCommand() {
        try {
            Object object = this.objStatus;
            synchronized (object) {
                this.nResponse = 255;
                this.nStatus = 0;
                this.outBuf = this.bWindows ? new byte[263] : new byte[4];
                this.outBuf[0] = 0;
                this.outBuf[1] = 0;
                this.outBuf[2] = 1;
                this.outBuf[3] = 0;
                this.port.sendData(this.outBuf, 4);
                this.objStatus.wait(8000L);
                this.nResponse = this.nStatus == 3 ? 6 : ((this.nStatus & 0x40) > 0 ? 7 : ((this.nStatus & 0x80) > 0 ? 21 : 239));
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error sending record: " + e.getMessage());
        }
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetCommand() {
        try {
            Object object = this.objStatus;
            synchronized (object) {
                this.nResponse = 255;
                this.nStatus = 0;
                this.outBuf = this.bWindows ? new byte[263] : new byte[4];
                this.outBuf[0] = 0;
                this.outBuf[1] = 0;
                this.outBuf[2] = 0;
                this.outBuf[3] = 64;
                this.port.sendData(this.outBuf, 4);
                this.objStatus.wait(8000L);
                this.nResponse = this.nStatus == 3 ? 6 : ((this.nStatus & 0x40) > 0 ? 7 : ((this.nStatus & 0x80) > 0 ? 21 : 239));
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error sending record: " + e.getMessage());
        }
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRecord(String sRecord) {
        try {
            Object object = this.objStatus;
            synchronized (object) {
                this.nResponse = 255;
                this.nStatus = 0;
                this.outBuf = this.bWindows ? new byte[263] : new byte[sRecord.length() + 4];
                this.outBuf[0] = 0;
                this.outBuf[1] = 0;
                this.outBuf[2] = 2;
                this.outBuf[3] = 0;
                for (int i = 0; i < sRecord.length(); ++i) {
                    this.outBuf[i + 4] = (byte)sRecord.charAt(i);
                }
                this.port.sendData(this.outBuf, sRecord.length() + 4);
                this.nRecordTimeout = 60000;
                this.objStatus.wait(this.nRecordTimeout);
                if (this.nStatus == 3) {
                    this.nResponse = 6;
                } else if ((this.nStatus & 0x40) > 0) {
                    this.nResponse = 7;
                } else if ((this.nStatus & 0x80) > 0) {
                    this.nResponse = 21;
                } else {
                    this.nResponse = 239;
                    this.log.log(this, "UNKWN response to sending record with timeout = " + this.nRecordTimeout);
                }
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error sending record: " + e.getMessage());
        }
        return this.nResponse;
    }

    public DLSCConfig getConfiguration() {
        return null;
    }

    public void enable() throws DLSException {
    }

    public void disable() throws DLSException {
    }

    public void doSelfTest() throws DLSException {
    }

    public boolean doHealthCheck() throws DLSException {
        return true;
    }

    public boolean isAlive() throws DLSException {
        return true;
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
    }

    public void reset() throws DLSException {
    }

    public void onDeviceAdded() {
    }

    public void onDeviceReattached() {
        if (this.bReattachPending) {
            this.bReattachPending = true;
            this.port.openPort();
        }
    }

    public void onDeviceRemoved() {
        if (!this.bReattachPending) {
            this.port.closePort();
            this.fireDeviceErrorEvent(-116);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        Object object = this.objStatus;
        synchronized (object) {
            if (inLen > 0) {
                this.nStatus = inBuf[0];
            }
            this.objStatus.notifyAll();
        }
    }
}

