/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class DLSSerialScanner
extends DLSScanner
implements DLSJposConst {
    protected int CMD_POS = 0;
    protected static final String enableCmd = "E";
    protected static final String disableCmd = "D";
    protected static final String resetCmd = "R";
    protected static final String notOnFileBeepCmd = "F";
    protected static final String enableBeepCmd = "\u0007";
    protected static final String beepIfBeepEnabledCmd = "B";
    protected static final String forceBeepCmd = "\u0001";
    protected static final String idRequestCmd = "i";
    protected static final String healthRequestCmd = "h";
    protected static final String statisticsCmd = "s";
    protected static final String readConfigCmd = "$c";
    protected static final String writeConfigCmd = "$C";
    protected static final String commitConfigCmd = "$As";
    protected static final byte[] cellPhoneModeControl = new byte[]{80, 1, 67};
    protected boolean bDIOCPMInProgress = false;
    protected Object objWaitDIOCPMResp = new Object();
    protected byte[] picTakingControl = new byte[]{80, 4, 112, 83, 66, 67};
    protected boolean bDIOPTCInProgress = false;
    protected boolean bDIOPTCStartInProgress = false;
    protected boolean bDIOPTCTransInProgress = false;
    protected Object objWaitDIOPTCTrans = new Object();
    protected long nPicFileSize = 0L;
    protected long nPicFileWritten = 0L;
    protected long nBaudDelay;
    protected int byte0 = 0;
    protected int byte1 = 0;
    protected int byte2 = 0;
    protected int byte3 = 0;
    String picFileName;
    FileOutputStream picFile;
    ByteArrayOutputStream picBuf;
    protected int nWaitingOnEot = 0;
    protected byte[] sohBuf;
    protected Object objWaitSohBuf = new Object();
    protected boolean bFirmware = false;
    protected boolean bReadConfigInProgress = false;
    protected boolean bIsEnabled = false;
    protected boolean bStatMessageSent = false;
    protected Object objWaitAck = new Object();
    protected Hashtable hTable;
    String decodeType = null;

    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg) {
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = null;
            this.sendMsg(msg);
            try {
                this.objWaitSohBuf.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRecord(String sRecord) {
        this.log.in(this, "sendRecord");
        Object object = this.objWaitAck;
        synchronized (object) {
            this.bFirmware = true;
            this.nResponse = 255;
            this.sendMsg(sRecord);
            try {
                this.objWaitAck.wait(this.nRecordTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendRecord: " + this.nResponse);
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendDIOCPMCommand(String sDIOCmnd) {
        this.log.in(this, "sendDIOCPMCommand");
        Object object = this.objWaitDIOCPMResp;
        synchronized (object) {
            this.bDIOCPMInProgress = true;
            this.nResponse = 255;
            this.sendMsg(sDIOCmnd);
            try {
                this.objWaitDIOCPMResp.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendDIOCPMCommand: " + this.nResponse);
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendCommitConfigItems(String commitCfgCmd) {
        this.log.in(this, "sendCommitConfigItems");
        Object object = this.objWaitDIOCPMResp;
        synchronized (object) {
            this.bDIOCPMInProgress = true;
            this.nResponse = 255;
            this.sendMsg(commitCfgCmd + "\r");
            try {
                this.objWaitDIOCPMResp.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendCommitConfigItems: " + this.nResponse);
        return this.nResponse;
    }

    public byte[] sendReadConfigCommand(String readCfgCmd, int[] data, Object object) {
        this.log.in(this, "sendReadConfigCommand");
        this.bReadConfigInProgress = true;
        ByteArrayOutputStream bsReturn = (ByteArrayOutputStream)object;
        String configItem = bsReturn.toString();
        String outCommand = readCfgCmd + configItem + "\r";
        this.nResponse = 255;
        byte[] myResponse = this.sendReceiveMsg(outCommand);
        this.log.out(this, "sendReadConfigCommand: " + this.nResponse);
        this.bReadConfigInProgress = false;
        return myResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendWriteConfigCommand(String commitCfgCmd, int[] data, Object object) {
        this.log.in(this, "sendWriteConfigCommand");
        String outCommand = commitCfgCmd + (String)object + "\r";
        Object object2 = this.objWaitDIOCPMResp;
        synchronized (object2) {
            this.bDIOCPMInProgress = true;
            this.nResponse = 255;
            this.sendMsg(outCommand);
            try {
                this.objWaitDIOCPMResp.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendWriteConfigCommand: " + this.nResponse);
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendDIOPTCCommand(String sDIOCmnd) {
        this.log.in(this, "sendDIOPTCCommand");
        this.bDIOPTCInProgress = true;
        this.bDIOPTCTransInProgress = false;
        this.bDIOPTCStartInProgress = false;
        this.picBuf = new ByteArrayOutputStream(40000);
        char resType = sDIOCmnd.charAt(3);
        long maxFileSize = resType == '0' ? 250000L : (resType == '1' ? 400000L : (resType == '2' ? 900000L : (resType == '3' ? 70000L : 500000L)));
        this.nBaudDelay = maxFileSize / (long)(this.deviceInfo.getBaud() / 10) * 1000L;
        this.nPicFileWritten = 0L;
        this.nResponse = 255;
        this.sendMsg(sDIOCmnd);
        Object object = this.objWaitDIOPTCTrans;
        synchronized (object) {
            try {
                this.objWaitDIOPTCTrans.wait(this.nBaudDelay);
                if (this.nPicFileWritten < this.nPicFileSize) {
                    this.nResponse = 21;
                }
                try {
                    this.picBuf.flush();
                    this.picFile = new FileOutputStream(this.picFileName, false);
                    this.picFile.write(this.picBuf.toByteArray(), 0, this.picBuf.size());
                    this.picFile.flush();
                    this.picFile.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            catch (InterruptedException ie2) {
                this.log.trace(this, "Interrupt exception " + ie2);
            }
        }
        this.log.out(this, "sendDIOPTKCommand: " + this.nResponse);
        return this.nResponse;
    }

    public void enable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(enableCmd);
        this.bIsEnabled = true;
    }

    public void disable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(disableCmd);
        this.bIsEnabled = true;
    }

    public void reset() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(resetCmd);
    }

    public void enableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(enableBeepCmd);
    }

    public void disableBeep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelfTest() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = null;
                this.sendMsg(statisticsCmd);
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf == null) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean doHealthCheck() throws DLSException {
        if (this.log.getFWBusy()) {
            return true;
        }
        boolean bRc = true;
        byte[] buf = this.sendReceiveMsg(healthRequestCmd);
        if (buf != null) {
            this.logHealthCheck(buf);
        } else {
            this.log.error(this, "Timeout on HealthCheck");
            bRc = false;
        }
        return bRc;
    }

    public boolean isAlive() {
        if (this.log.getFWBusy()) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    public void setFirmwareBaudRate() {
        this.log.in(this, "setFirmwareBaudRate");
        int nOrigBaud = this.deviceInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud > nOrigBaud) {
            this.port.changeBaudRate(nBaud);
            if (!this.isAlive()) {
                this.port.changeBaudRate(nOrigBaud);
            }
        }
        this.log.out(this, "setFirmwareBaudRate");
    }

    public void restoreBaudRate() {
        this.log.in(this, "restoreBaudRate");
        int nOrigBaud = this.deviceInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud != nOrigBaud) {
            this.port.changeBaudRate(nOrigBaud);
        }
        this.log.out(this, "restoreBaudRate");
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void updateConfiguration() {
    }

    public DLSScannerConfig reportConfiguration() {
        return this.scannerConfig;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        boolean bWhatState = this.bIsEnabled;
        this.log.in(this, "directIO");
        String strResult = "Invalid Command";
        int nResp = 0;
        if (this.bIsEnabled) {
            this.disable();
        }
        block1 : switch (command) {
            case 1: {
                this.sendMsg(resetCmd);
                strResult = "Scanner reset";
                break;
            }
            case 11: {
                this.sendMsg(beepIfBeepEnabledCmd);
                strResult = "Scanner beeped";
                break;
            }
            case 342: {
                byte[] myResponse = this.sendReadConfigCommand(new String(readConfigCmd), data, object);
                if (myResponse == null) {
                    data[0] = 21;
                    strResult = "ERROR: Read Config Item failed";
                    break;
                }
                strResult = new String(myResponse);
                if (myResponse.length == 1) {
                    nResp = myResponse[0];
                }
                strResult = "Read Config Item:" + strResult;
                if (nResp != 0) {
                    switch (nResp) {
                        case 7: {
                            data[0] = 7;
                            strResult = "ERROR: Invalid config item or data out of range";
                            break;
                        }
                        case 21: {
                            data[0] = 21;
                            strResult = "ERROR: Malformed config item and/or data";
                        }
                    }
                    break;
                }
                data[0] = 6;
                break;
            }
            case 343: {
                nResp = this.sendWriteConfigCommand(new String(writeConfigCmd), data, object);
                strResult = "Write Config Iterm:";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Config item does not exist";
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Invalid config item or data out of range";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Config item accepted";
                        break;
                    }
                    case 24: {
                        data[0] = 24;
                        strResult = "ERROR: Malformed config item and/or data";
                    }
                }
                break;
            }
            case 344: {
                strResult = "Config commited to scanner memory";
                nResp = this.sendCommitConfigItems(new String(commitConfigCmd));
                strResult = "Config Items commited:";
                if (nResp == 0) break;
                switch (nResp) {
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Commit accepted";
                        break;
                    }
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Commit failed";
                    }
                }
                break;
            }
            case 340: {
                nResp = this.sendDIOCPMCommand(new String(cellPhoneModeControl));
                strResult = "Cell phone mode control";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Cell phone mode not configured";
                        break;
                    }
                    case 23: {
                        data[0] = 23;
                        strResult = "ERROR: Scanner currently taking picture";
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Cell phone mode active and in progress";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: One-shot cell phone mode activated";
                        break;
                    }
                    case 84: {
                        data[0] = 84;
                        strResult = "OK: Toggle mode activated";
                        break;
                    }
                    case 116: {
                        data[0] = 116;
                        strResult = "OK: Toggle mode deactivated";
                    }
                }
                break;
            }
            case 341: {
                this.picTakingControl[3] = (byte)object.toString().charAt(0);
                this.picTakingControl[4] = (byte)object.toString().charAt(1);
                this.picTakingControl[5] = (byte)object.toString().charAt(2);
                this.picFileName = object.toString();
                this.picFileName = this.picFileName.substring(3);
                if (this.picFileName.length() == 0) {
                    this.picFileName = "temp.jpg";
                }
                nResp = this.sendDIOPTCCommand(new String(this.picTakingControl));
                strResult = "Picture Taking Control";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Picture taking not configured";
                        break block1;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Picture saved as " + this.picFileName;
                        break block1;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Picture transfer incomplete";
                    }
                }
            }
        }
        try {
            ByteArrayOutputStream bsReturn = (ByteArrayOutputStream)object;
            bsReturn.reset();
            if (bsReturn instanceof ByteArrayOutputStream) {
                bsReturn.write(strResult.getBytes());
            } else {
                object = strResult;
            }
        }
        catch (Exception e) {
            this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
            object = strResult;
        }
        if (bWhatState) {
            this.enable();
        }
        this.log.out(this, "directIO");
    }

    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    public Hashtable getStatistics() throws DLSException {
        String truncated2;
        String truncated;
        this.log.in(this, "getStatistics");
        Hashtable<String, String> table = new Hashtable<String, String>();
        String put = table.put(DLS_S_GOOD_SCAN_COUNT, "NA");
        if (this.log.getFWBusy()) {
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            return table;
        }
        String[] strInfo = null;
        String str = null;
        int i = 0;
        this.log.log(this, "Getting idRequestCmd");
        this.bStatMessageSent = true;
        byte[] buf = this.sendReceiveMsg(idRequestCmd);
        String logData = "";
        if (buf != null) {
            for (i = 0; i < buf.length; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
            put = table.put("RawInfo", "# bytes received[" + buf.length + "]" + logData);
        }
        if (buf != null && buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block44: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'M': {
                        put = table.put(DLS_S_MODEL_NAME, truncated2.substring(1));
                        continue block44;
                    }
                    case 'S': {
                        put = table.put(DLS_S_SERIAL_NUMBER, truncated2.substring(1));
                        continue block44;
                    }
                    case 'm': {
                        put = table.put(DLS_S_SCANNER_BOARD_SERIAL, truncated2.substring(1));
                        continue block44;
                    }
                    case 'A': {
                        put = table.put(DLS_S_FIRMWARE_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'R': {
                        put = table.put(DLS_S_SCANNER_REVISION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'C': {
                        put = table.put(DLS_S_SCANNER_CONFIG_FILE_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'B': {
                        put = table.put(DLS_S_SCANNER_BOOT_ROM_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'H': {
                        put = table.put(DLS_S_HARDWARE_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'U': {
                        put = table.put(DLS_S_UNIVERSAL_ROM_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'u': {
                        put = table.put(DLS_S_UNIVERSAL_BOOT_ROM_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'W': {
                        put = table.put(DLS_S_SCALE_INFO, truncated2.substring(1));
                        continue block44;
                    }
                    case 'D': {
                        put = table.put(DLS_S_DISPLAY_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'E': {
                        put = table.put(DLS_S_EAS_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'I': {
                        put = table.put(DLS_S_SCANNER_INTERFACE, truncated2.substring(1));
                        continue block44;
                    }
                    case 'r': {
                        put = table.put(DLS_SECONDARY_RADIO_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'L': {
                        put = table.put(DLS_SECONDARY_RADIO_APP_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'b': {
                        put = table.put(DLS_SECONDARY_RADIO_BOOTLOADER_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'X': {
                        put = table.put(DLS_SECONDARY_MODEL_NAME, truncated2.substring(1));
                    }
                }
            }
        }
        this.log.log(this, "Getting healthRequestCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(healthRequestCmd);
        logData = "";
        if (buf != null) {
            for (i = 0; i < buf.length; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
            put = table.put("RawHealth", "# bytes received[" + buf.length + "]" + logData);
        }
        if (buf != null && buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block46: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'm': {
                        put = table.put(DLS_S_MOTOR_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'h': {
                        put = table.put(DLS_S_V_LASER_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'v': {
                        put = table.put(DLS_S_H_LASER_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 's': {
                        put = table.put(DLS_S_SCALE_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'd': {
                        put = table.put(DLS_S_REMOTE_DISPLAY_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'e': {
                        put = table.put(DLS_S_EAS_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'c': {
                        put = table.put(DLS_S_CAMERA_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'r': {
                        put = table.put(DLS_HH_RADIO_HEALTH, truncated2.substring(1));
                    }
                }
            }
        }
        this.log.log(this, "Getting statisticsCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(statisticsCmd);
        logData = "";
        if (buf != null) {
            for (i = 0; i < buf.length; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
            put = table.put("RawStats", "# bytes received[" + buf.length + "]" + logData);
        }
        if (buf != null && buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block48: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'P': {
                        put = table.put(DLS_S_HOURS_POWERED_COUNT, truncated2.substring(1));
                        continue block48;
                    }
                    case 'm': {
                        put = table.put(DLS_S_MOTOR_TIME, truncated2.substring(1));
                        continue block48;
                    }
                    case 'l': {
                        put = table.put(DLS_S_LASER_TIME, truncated2.substring(1));
                        continue block48;
                    }
                    case 'L': {
                        put = table.put(DLS_S_GOOD_SCAN_COUNT, truncated2.substring(1));
                        continue block48;
                    }
                    case 'z': {
                        put = table.put(DLS_S_SCALE_ZEROS, truncated2.substring(1));
                        continue block48;
                    }
                    case 'c': {
                        put = table.put(DLS_S_SCALE_CALS, truncated2.substring(1));
                        continue block48;
                    }
                    case 'E': {
                        put = table.put(DLS_S_EAS_DEACTIVATED, truncated2.substring(1));
                        continue block48;
                    }
                    case 'e': {
                        put = table.put(DLS_S_EAS_MANUAL, truncated2.substring(1));
                        continue block48;
                    }
                    case 'B': {
                        put = table.put(DLS_SECONDARY_BATTERY_CHG_CYCLES, truncated2.substring(1));
                        continue block48;
                    }
                    case 'T': {
                        put = table.put(DLS_SECONDARY_TRIGGER_PULLS, truncated2.substring(1));
                        continue block48;
                    }
                    case 'K': {
                        put = table.put(DLS_SECONDARY_KEY_PRESSES, truncated2.substring(1));
                    }
                }
            }
        }
        if (!table.contains(DLS_S_INTERFACE)) {
            put = table.put(DLS_S_INTERFACE, "RS232");
        }
        put = table.put(DLS_S_MANUFACTURE_NAME, "DLA");
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
        this.bStatMessageSent = false;
        this.hTable = table;
        return table;
    }

    public Hashtable returnStatistics() throws DLSException {
        return this.hTable;
    }

    protected void parseReadConfigMessages(byte[] inBuf, byte endChar) {
        for (int i = 0; i < inBuf.length; ++i) {
            this.bs.write(inBuf[i]);
            if (inBuf[i] != endChar) continue;
            byte[] tmpBuf = this.bs.toByteArray();
            boolean add = this.msgList.add(tmpBuf);
            this.bs.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        if (this.bFirmware) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                this.log.out(this, "onDataReceived:" + this.nResponse);
                this.objWaitAck.notify();
                return;
            }
        }
        if (this.bDIOCPMInProgress) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitDIOCPMResp;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bDIOCPMInProgress = false;
                this.log.out(this, "onDataReceived:" + this.nResponse);
                this.objWaitDIOCPMResp.notify();
                return;
            }
        }
        if (this.bDIOPTCInProgress) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                this.nResponse = inBuf[0];
                if (this.nResponse == 6) {
                    System.out.println("ACK received.");
                    System.out.println(inLen);
                    this.bDIOPTCStartInProgress = true;
                } else {
                    this.objWaitDIOPTCTrans.notify();
                    System.out.println("Non-ACK received.");
                }
                this.log.out(this, "onDataReceived:" + this.nResponse);
                this.bDIOPTCInProgress = false;
                return;
            }
        }
        if (this.bDIOPTCStartInProgress) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                this.byte0 = 0xFF & inBuf[0];
                this.byte1 = 0xFF & inBuf[1];
                this.byte2 = 0xFF & inBuf[2];
                this.byte3 = 0xFF & inBuf[3];
                this.nPicFileSize = (long)(this.byte0 << 24 | this.byte1 << 16 | this.byte2 << 8 | this.byte3) & 0xFFFFFFFFL;
                System.out.println("File size bytes:");
                System.out.println(inBuf[0]);
                System.out.println(inBuf[1]);
                System.out.println(inBuf[2]);
                System.out.println(inBuf[3]);
                if (this.nPicFileSize != 0L) {
                    this.bDIOPTCTransInProgress = true;
                    this.picBuf.write(inBuf, 4, inLen - 4);
                    this.nPicFileWritten += (long)(inLen - 4);
                    System.out.print("Start ");
                    System.out.print(this.nPicFileWritten);
                    System.out.print("  ");
                    System.out.print(inLen);
                    System.out.print("  ");
                    System.out.println(this.nPicFileSize);
                } else {
                    this.nResponse = 21;
                    this.objWaitDIOPTCTrans.notify();
                    System.out.println("Reported file size is zero.");
                }
                this.bDIOPTCStartInProgress = false;
                return;
            }
        }
        if (this.bDIOPTCTransInProgress) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                this.picBuf.write(inBuf, 0, inLen);
                this.nPicFileWritten += (long)inLen;
                System.out.print("Buffering ");
                System.out.print(this.nPicFileWritten);
                System.out.print("  ");
                System.out.print(inLen);
                System.out.print("  ");
                System.out.println(this.nPicFileSize);
                if (this.nPicFileWritten >= this.nPicFileSize) {
                    this.bDIOPTCTransInProgress = false;
                    this.objWaitDIOPTCTrans.notify();
                }
                return;
            }
        }
        if (this.bReadConfigInProgress) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.parseReadConfigMessages(inBuf, this.deviceInfo.getRxTrailer());
                this.sohBuf = (byte[])this.msgList.get(0);
                this.log.out(this, "onDataReceived:" + this.sohBuf.toString());
                return;
            }
        }
        if (this.bs.size() == 0 && inBuf[0] == 1 || this.nWaitingOnEot > 0) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                ++this.nWaitingOnEot;
                this.parseMessages(inBuf, (byte)4);
                if (this.msgList.size() > 0) {
                    this.nWaitingOnEot = 0;
                    this.sohBuf = (byte[])this.msgList.get(0);
                    this.msgList.clear();
                    this.objWaitSohBuf.notifyAll();
                } else if (this.nWaitingOnEot > 30) {
                    this.nWaitingOnEot = 0;
                    this.bs.reset();
                    this.msgList.clear();
                }
            }
            return;
        }
        this.parseMessages(inBuf, this.deviceInfo.getRxTrailer());
        if (!this.bIsEnabled) {
            this.sohBuf = (byte[])this.msgList.get(0);
            return;
        }
        this.decodeType = this.deviceInfo.getDecodingType();
        Iterator it = this.msgList.iterator();
        while (it.hasNext()) {
            byte[] tmpBuf = (byte[])it.next();
            byte pre = this.deviceInfo.getRxPrefix();
            if (tmpBuf.length <= 2) continue;
            if (pre == tmpBuf[0]) {
                this.CMD_POS = 1;
            }
            int nType = this.extractBarcodeType(tmpBuf[this.CMD_POS], tmpBuf[this.CMD_POS + 1]);
            byte[] barcode = this.extractBarcodeLabel(tmpBuf, 0);
            switch (nType) {
                case 101: {
                    if (barcode.length <= 12) break;
                    nType = 111;
                    break;
                }
                case 102: {
                    if (barcode.length <= 8) break;
                    nType = 112;
                    break;
                }
                case 103: {
                    if (barcode.length <= 8) break;
                    nType = 118;
                    break;
                }
                case 104: {
                    if (barcode.length <= 13) break;
                    nType = 119;
                }
            }
            DLSProperties options = DLSProperties.getInstance();
            this.bSendCookedData = options.get("com.dls.jpos.service.ScannerService.sendCookedData", false);
            if (this.bSendCookedData) {
                tmpBuf = barcode;
            }
            this.fireLabelReceivedEvent(tmpBuf, barcode, nType);
        }
        this.msgList.clear();
    }
}

