/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class DLSProperties {
    private static DLSProperties sm_instance;
    protected Properties prop = null;
    protected Vector eventListeners = new Vector();

    private DLSProperties() {
    }

    public void addEventListener(PropertiesListener pl) {
        this.eventListeners.addElement(pl);
    }

    public void removeEventListener(PropertiesListener pl) {
        this.eventListeners.removeElement(pl);
    }

    protected void fireOptionsLoadedEvent() {
        Enumeration e = this.eventListeners.elements();
        while (e.hasMoreElements()) {
            PropertiesListener listener = (PropertiesListener)e.nextElement();
            listener.onOptionsLoaded();
        }
    }

    protected void fireOptionsSavedEvent() {
        Enumeration e = this.eventListeners.elements();
        while (e.hasMoreElements()) {
            PropertiesListener listener = (PropertiesListener)e.nextElement();
            listener.onOptionsSaved();
        }
    }

    protected void load() {
        try {
            boolean bSave = false;
            this.prop = new Properties();
            InputStream inProp = null;
            try {
                inProp = new FileInputStream("dls.properties");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (inProp == null) {
                inProp = this.getClass().getResourceAsStream("dls.properties");
                bSave = true;
            }
            if (inProp != null) {
                this.prop.load(inProp);
                inProp = null;
                if (bSave) {
                    this.save();
                }
            }
            this.fireOptionsLoadedEvent();
        }
        catch (IOException ioe) {
            System.out.print("error loading options file: " + ioe.getMessage());
        }
    }

    public int get(String strOption, int nDefault) {
        String strValue = this.prop.getProperty(strOption);
        String strDefault = Integer.toString(nDefault);
        if (strValue == null) {
            this.prop.setProperty(strOption, strDefault);
            strValue = strDefault;
            this.save();
        }
        nDefault = Integer.parseInt(strValue);
        return nDefault;
    }

    public boolean get(String strOption, boolean bDefault) {
        String strDefault;
        String strValue = this.prop.getProperty(strOption);
        String string = strDefault = bDefault ? "true" : "false";
        if (strValue == null) {
            this.prop.setProperty(strOption, strDefault);
            strValue = strDefault;
            this.save();
        }
        bDefault = strValue.equals("1") || strValue.equals("-1") || strValue.toUpperCase().equals("TRUE");
        return bDefault;
    }

    public String get(String strOption, String strDefault) {
        String strValue = this.prop.getProperty(strOption);
        if (strValue == null) {
            this.prop.setProperty(strOption, strDefault);
            strValue = strDefault;
            this.save();
        }
        return strValue;
    }

    public void set(String strOption, String strValue) {
        this.prop.setProperty(strOption, strValue);
    }

    public void set(String strOption, boolean bValue) {
        String strValue = bValue ? "true" : "false";
        this.set(strOption, strValue);
    }

    public void set(String strOption, int nValue) {
        String strValue = Integer.toString(nValue);
        this.set(strOption, strValue);
    }

    public void save() {
        try {
            FileOutputStream outProp = new FileOutputStream("dls.properties");
            this.prop.store(outProp, "DLSJavaPOS properties file. Copyright (C) Datalogic ADC");
            this.fireOptionsSavedEvent();
        }
        catch (FileNotFoundException fnfe) {
            System.out.print("save: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.out.print("save: " + ioe.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized DLSProperties getInstance() {
        if (sm_instance == null) {
            sm_instance = new DLSProperties();
            sm_instance.load();
        }
        return sm_instance;
    }

    public static interface PropertiesListener {
        public void onOptionsLoaded();

        public void onOptionsSaved();
    }
}

