/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSLogManager;
import com.dls.jpos.interpretation.DLS8xxxScanner;
import com.dls.jpos.interpretation.DLSPortalScanner;
import com.dls.jpos.interpretation.DLSSCSerialScale;
import com.dls.jpos.interpretation.DLSSCSerialScanner;
import com.dls.jpos.interpretation.DLSScale;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DLSSerialScale;
import com.dls.jpos.interpretation.DLSSerialScanner;
import com.dls.jpos.interpretation.DLSUSBScale;
import com.dls.jpos.interpretation.DLSUSBScanner;
import com.dls.jpos.transport.DLSPort;
import com.dls.jpos.transport.DLSSerialPort;
import com.dls.jpos.transport.DLSTCPIPPort;
import com.dls.jpos.transport.DLSUsbJavax;
import com.dls.jpos.transport.DLSUsbWin32;
import java.util.Hashtable;

public class DLSObjectFactory {
    private static int comPort = 0;
    private static Hashtable hashPorts = new Hashtable();
    protected static DLSLogManager log = DLSLogManager.getInstance();
    protected static DLSObjectFactory traceObj = new DLSObjectFactory();
    public static final String TCPIP_DEVICE_BUS = "TCPIP";

    public static DLSPort createPort(DLSDeviceInfo di) throws DLSException {
        log.in(traceObj, "createPort()");
        String bus = di.getDeviceBus();
        if (bus.equals("USB") || bus.equals("HID")) {
            if (di.getUsage() != 0) {
                if (DLSObjectFactory.log.strOS.indexOf(new String("WINDOWS")) >= 0) {
                    log.out(traceObj, "createPort() - WindowsUSB");
                    return new DLSUsbWin32(di);
                }
                log.out(traceObj, "createPort() - LinuxUSB");
                return new DLSUsbJavax(di);
            }
            log.error(traceObj, "USB defined, but no USAGE ID available - createPort() error.");
            throw new DLSException(-2147483645, "Error creating port");
        }
        if (bus.equals(TCPIP_DEVICE_BUS)) {
            log.out(traceObj, "createPort() - TCPIP");
            return new DLSTCPIPPort(di);
        }
        DLSSerialPort p = (DLSSerialPort)hashPorts.get(new Integer(di.getPort()));
        if (p == null) {
            p = new DLSSerialPort(di);
            DLSSerialPort dLSSerialPort = hashPorts.put(new Integer(di.getPort()), p);
        }
        log.out(traceObj, "createPort() - Serialport");
        return p;
    }

    public static DLSScanner createScanner(String strLogicalName) throws DLSException {
        log.in(traceObj, "createScanner");
        DLSScanner scanner = null;
        DLSDeviceInfo deviceInfo = new DLSDeviceInfo();
        deviceInfo.loadConfiguration(strLogicalName);
        if (deviceInfo.getDeviceBus().equals("USB") || deviceInfo.getDeviceBus().equals("HID")) {
            log.trace(traceObj, "create DLSUSBScanner()");
            scanner = new DLSUSBScanner();
        } else if (deviceInfo.getDeviceBus().equals("RS232")) {
            if (deviceInfo.getSingleCable()) {
                log.trace(traceObj, "create DLSSCSerialScanner()");
                scanner = new DLSSCSerialScanner();
            } else if (deviceInfo.get8xxx()) {
                log.trace(traceObj, "create DLS8xxxScanner()");
                scanner = new DLS8xxxScanner();
            } else {
                log.trace(traceObj, "create DLSSerialScanner()");
                scanner = new DLSSerialScanner();
            }
        } else if (deviceInfo.getDeviceBus().equals(TCPIP_DEVICE_BUS)) {
            log.trace(traceObj, "create DLSPortalScanner()");
            scanner = new DLSPortalScanner();
        } else {
            log.error(traceObj, "Unable to detect scanner connect type.  Configuration ERROR in jpos.xml");
            throw new DLSException(-2147483643, "jpos.xml config error");
        }
        log.out(traceObj, "createScanner");
        return scanner;
    }

    public static DLSScale createScale(String strLogicalName) throws DLSException {
        log.in(traceObj, "createScale");
        DLSScale scale = null;
        DLSDeviceInfo deviceInfo = new DLSDeviceInfo();
        deviceInfo.loadConfiguration(strLogicalName);
        if (deviceInfo.getDeviceBus().equals("USB") || deviceInfo.getDeviceBus().equals("HID")) {
            log.trace(traceObj, "create DLSUSBScale()");
            scale = new DLSUSBScale();
        } else if (deviceInfo.getDeviceBus().equals("RS232")) {
            if (deviceInfo.getSingleCable()) {
                log.trace(traceObj, "create DLSSCSerialScale()");
                scale = new DLSSCSerialScale();
            } else {
                log.trace(traceObj, "create DLSSerialScale()");
                scale = new DLSSerialScale();
            }
        } else {
            log.error(traceObj, "Unable to detect scale connect type.  Configuration ERROR in jpos.xml");
            throw new DLSException(-2147483643, "jpos.xml config error");
        }
        log.out(traceObj, "createScale");
        return scale;
    }
}

